/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.mailer.smtp;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.sal.api.component.ComponentLocator;
import com.sun.mail.smtp.SMTPSSLTransport;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.NormalizedVersion;
import net.savignano.snotify.atlassian.common.security.ClassLoaderEnforcer;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.snotify.atlassian.mailer.MessageAndAddress;
import net.savignano.snotify.bitbucket.mailer.BitbucketMailer;
import net.savignano.snotify.bitbucket.mailer.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifySmtpsTransport
extends SMTPSSLTransport {
    private static final Logger log = LoggerFactory.getLogger(SnotifySmtpsTransport.class);
    private static Boolean integrityIntact;
    private final BitbucketMailer mailer;

    private static final boolean checkIntegrity() {
        if (integrityIntact != null) {
            return integrityIntact;
        }
        ApplicationPropertiesService appProperties = (ApplicationPropertiesService)ComponentLocator.getComponent(ApplicationPropertiesService.class);
        NormalizedVersion bitbucketVersion = new NormalizedVersion(appProperties.getBuildVersion());
        if (bitbucketVersion.isLowerThan(new NormalizedVersion(7, 14))) {
            log.warn("Bitbucket version {} detected. Skipping signature check.", (Object)bitbucketVersion);
            integrityIntact = true;
        } else {
            integrityIntact = SecurityUtil.checkSnotifyIntegrity();
        }
        return integrityIntact;
    }

    public SnotifySmtpsTransport(Session session, URLName urlname) {
        super(session, urlname);
        log.info("Using S/Notify SMTPS transport implementation to send emails.");
        log.trace("Session properties used: {}", (Object)session.getProperties());
        this.mailer = new BitbucketMailer(session, PropertiesUtil.getAppProps(), PropertiesUtil.getUserProps(), PropertiesUtil.getProjectProps());
    }

    public synchronized void sendMessage(Message message, Address[] addresses) throws MessagingException {
        if (!SnotifySmtpsTransport.checkIntegrity()) {
            log.error("Signature of S/Notify is not correct. To protect underlying system, S/Notify will be disabled, as it has been tampered with.");
            super.sendMessage(message, addresses);
            return;
        }
        if (!(message instanceof MimeMessage)) {
            log.error("Can't encrypt email, because it is not a MIME email but: " + message.getClass().getCanonicalName());
            throw new MessagingException("Can't send email with message number " + message.getMessageNumber() + ". It is not a MIME email.");
        }
        ClassLoaderEnforcer enforcer = new ClassLoaderEnforcer(((Object)((Object)this)).getClass().getClassLoader());
        enforcer.run((t, u) -> {
            try {
                this.sendMessageToAddresses((Message)t, (Address[])u);
            }
            catch (MessagingException e1) {
                enforcer.setException((Exception)((Object)e1));
            }
        }, message, addresses);
        if (enforcer.getException() != null) {
            throw (MessagingException)((Object)enforcer.getException());
        }
    }

    private void sendMessageToAddresses(Message message, Address[] addresses) throws MessagingException {
        MessageAndAddress[] result;
        SecurityService securityService = (SecurityService)ComponentLocator.getComponent(SecurityService.class);
        EscalatedSecurityContext adminPerm = securityService.withPermission(Permission.ADMIN, "S/Notify needs admin permissions, to be able to encrypt and sign messages.");
        UncheckedOperation getMessagesOperation = () -> this.mailer.getMessages((MimeMessage)message, addresses);
        try {
            result = (MessageAndAddress[])adminPerm.call((Operation)getMessagesOperation);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new MessagingException("Error generating emails: " + e.getMessage(), e);
        }
        this.sendMessages(result);
    }

    private void sendMessages(MessageAndAddress[] emails) throws MessagingException {
        MessagingException e = null;
        for (MessageAndAddress email : emails) {
            if (email == null || email.message == null || email.address == null) continue;
            try {
                if (Boolean.parseBoolean(email.message.getHeader("X-SNotify-Do-Not-Send", null))) {
                    log.info("Not delivering email to \"{}\", as S/Notify's ignore header was set.", (Object)email.address);
                    continue;
                }
                log.debug("Delivering email to: \"{}\"", (Object)email.address);
                super.sendMessage((Message)email.message, new Address[]{email.address});
            }
            catch (MessagingException e1) {
                log.error(e1.getMessage(), (Throwable)e1);
                if (e != null) continue;
                e = e1;
            }
        }
        if (e != null) {
            throw new MessagingException("Error sending mail: " + e.getMessage(), e);
        }
    }
}

