/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.its;

import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.its.ITSPublicEncryptionKey;
import net.savignano.thirdparty.org.bouncycastle.its.ITSValidityPeriod;
import net.savignano.thirdparty.org.bouncycastle.its.operator.ECDSAEncoder;
import net.savignano.thirdparty.org.bouncycastle.its.operator.ITSContentVerifierProvider;
import net.savignano.thirdparty.org.bouncycastle.oer.OEREncoder;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Certificate;
import net.savignano.thirdparty.org.bouncycastle.oer.its.IssuerIdentifier;
import net.savignano.thirdparty.org.bouncycastle.oer.its.PublicEncryptionKey;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Signature;
import net.savignano.thirdparty.org.bouncycastle.oer.its.template.IEEE1609dot2;
import net.savignano.thirdparty.org.bouncycastle.operator.ContentVerifier;
import net.savignano.thirdparty.org.bouncycastle.util.Encodable;

public class ITSCertificate
implements Encodable {
    private final Certificate certificate;

    public ITSCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public IssuerIdentifier getIssuer() {
        return this.certificate.getCertificateBase().getIssuer();
    }

    public ITSValidityPeriod getValidityPeriod() {
        return new ITSValidityPeriod(this.certificate.getCertificateBase().getToBeSignedCertificate().getValidityPeriod());
    }

    public ITSPublicEncryptionKey getPublicEncryptionKey() {
        PublicEncryptionKey encryptionKey = this.certificate.getCertificateBase().getToBeSignedCertificate().getEncryptionKey();
        if (encryptionKey != null) {
            return new ITSPublicEncryptionKey(encryptionKey);
        }
        return null;
    }

    public boolean isSignatureValid(ITSContentVerifierProvider verifierProvider) throws Exception {
        ContentVerifier contentVerifier = verifierProvider.get(this.certificate.getCertificateBase().getSignature().getChoice());
        OutputStream verOut = contentVerifier.getOutputStream();
        verOut.write(OEREncoder.toByteArray(this.certificate.getCertificateBase().getToBeSignedCertificate(), IEEE1609dot2.tbsCertificate));
        verOut.close();
        Signature sig = this.certificate.getCertificateBase().getSignature();
        return contentVerifier.verify(ECDSAEncoder.toX962(sig));
    }

    public Certificate toASN1Structure() {
        return this.certificate;
    }

    public byte[] getEncoded() throws IOException {
        return OEREncoder.toByteArray(this.certificate.getCertificateBase(), IEEE1609dot2.certificate);
    }
}

