/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.its.ITSCertificate;
import net.savignano.thirdparty.org.bouncycastle.its.ITSValidityPeriod;
import net.savignano.thirdparty.org.bouncycastle.oer.its.CrlSeries;
import net.savignano.thirdparty.org.bouncycastle.oer.its.HashedId;
import net.savignano.thirdparty.org.bouncycastle.oer.its.PsidGroupPermissions;
import net.savignano.thirdparty.org.bouncycastle.oer.its.PsidSsp;
import net.savignano.thirdparty.org.bouncycastle.oer.its.SequenceOfPsidGroupPermissions;
import net.savignano.thirdparty.org.bouncycastle.oer.its.SequenceOfPsidSsp;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ToBeSignedCertificate;

public class ITSCertificateBuilder {
    protected final ToBeSignedCertificate.Builder tbsCertificateBuilder;
    protected final ITSCertificate issuer;
    protected ASN1Integer version = new ASN1Integer(3L);
    protected HashedId cracaId = new HashedId.HashedId3(new byte[3]);
    protected CrlSeries crlSeries = new CrlSeries(0);

    public ITSCertificateBuilder(ToBeSignedCertificate.Builder tbsCertificateBuilder) {
        this(null, tbsCertificateBuilder);
    }

    public ITSCertificateBuilder(ITSCertificate issuer, ToBeSignedCertificate.Builder tbsCertificateBuilder) {
        this.issuer = issuer;
        this.tbsCertificateBuilder = tbsCertificateBuilder;
        this.tbsCertificateBuilder.setCracaId(this.cracaId);
        this.tbsCertificateBuilder.setCrlSeries(this.crlSeries);
    }

    public ITSCertificate getIssuer() {
        return this.issuer;
    }

    public ITSCertificateBuilder setVersion(int version) {
        this.version = new ASN1Integer(version);
        return this;
    }

    public ITSCertificateBuilder setCracaId(byte[] cracaId) {
        this.cracaId = new HashedId.HashedId3(cracaId);
        this.tbsCertificateBuilder.setCracaId(this.cracaId);
        return this;
    }

    public ITSCertificateBuilder setCrlSeries(int crlSeries) {
        this.crlSeries = new CrlSeries(crlSeries);
        this.tbsCertificateBuilder.setCrlSeries(this.crlSeries);
        return this;
    }

    public ITSCertificateBuilder setValidityPeriod(ITSValidityPeriod validityPeriod) {
        this.tbsCertificateBuilder.setValidityPeriod(validityPeriod.toASN1Structure());
        return this;
    }

    public ITSCertificateBuilder setCertIssuePermissions(PsidGroupPermissions ... permissions) {
        this.tbsCertificateBuilder.setCertIssuePermissions(SequenceOfPsidGroupPermissions.builder().addGroupPermission(permissions).createSequenceOfPsidGroupPermissions());
        return this;
    }

    public ITSCertificateBuilder setAppPermissions(PsidSsp ... psidSsps) {
        SequenceOfPsidSsp.Builder bldr = SequenceOfPsidSsp.builder();
        for (int i = 0; i != psidSsps.length; ++i) {
            bldr.setItem(psidSsps[i]);
        }
        this.tbsCertificateBuilder.setAppPermissions(bldr.createSequenceOfPsidSsp());
        return this;
    }
}

