/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.math.ec.AbstractECLookupTable;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECConstants;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECCurve;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECFieldElement;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECLookupTable;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECMultiplier;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECPoint;
import net.savignano.thirdparty.org.bouncycastle.math.ec.WTauNafMultiplier;
import net.savignano.thirdparty.org.bouncycastle.math.ec.custom.sec.SecT571FieldElement;
import net.savignano.thirdparty.org.bouncycastle.math.ec.custom.sec.SecT571K1Point;
import net.savignano.thirdparty.org.bouncycastle.math.raw.Nat576;
import net.savignano.thirdparty.org.bouncycastle.util.encoders.Hex;

public class SecT571K1Curve
extends ECCurve.AbstractF2m {
    private static final int SECT571K1_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT571K1_AFFINE_ZS = new ECFieldElement[]{new SecT571FieldElement(ECConstants.ONE)};
    protected SecT571K1Point infinity = new SecT571K1Point(this, null, null);

    public SecT571K1Curve() {
        super(571, 2, 5, 10);
        this.a = this.fromBigInteger(BigInteger.valueOf(0L));
        this.b = this.fromBigInteger(BigInteger.valueOf(1L));
        this.order = new BigInteger(1, Hex.decodeStrict("020000000000000000000000000000000000000000000000000000000000000000000000131850E1F19A63E4B391A8DB917F4138B630D84BE5D639381E91DEB45CFE778F637C1001"));
        this.cofactor = BigInteger.valueOf(4L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT571K1Curve();
    }

    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    protected ECMultiplier createDefaultMultiplier() {
        return new WTauNafMultiplier();
    }

    public int getFieldSize() {
        return 571;
    }

    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecT571FieldElement(x);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y) {
        return new SecT571K1Point(this, x, y);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs) {
        return new SecT571K1Point(this, x, y, zs);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return true;
    }

    public int getM() {
        return 571;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 5;
    }

    public int getK3() {
        return 10;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int FE_LONGS = 9;
        final long[] table = new long[len * 9 * 2];
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            ECPoint p = points[off + i];
            Nat576.copy64(((SecT571FieldElement)p.getRawXCoord()).x, 0, table, pos);
            Nat576.copy64(((SecT571FieldElement)p.getRawYCoord()).x, 0, table, pos += 9);
            pos += 9;
        }
        return new AbstractECLookupTable(){

            public int getSize() {
                return len;
            }

            public ECPoint lookup(int index) {
                long[] x = Nat576.create64();
                long[] y = Nat576.create64();
                int pos = 0;
                for (int i = 0; i < len; ++i) {
                    long MASK = (i ^ index) - 1 >> 31;
                    for (int j = 0; j < 9; ++j) {
                        int n = j;
                        x[n] = x[n] ^ table[pos + j] & MASK;
                        int n2 = j;
                        y[n2] = y[n2] ^ table[pos + 9 + j] & MASK;
                    }
                    pos += 18;
                }
                return this.createPoint(x, y);
            }

            public ECPoint lookupVar(int index) {
                long[] x = Nat576.create64();
                long[] y = Nat576.create64();
                int pos = index * 9 * 2;
                for (int j = 0; j < 9; ++j) {
                    x[j] = table[pos + j];
                    y[j] = table[pos + 9 + j];
                }
                return this.createPoint(x, y);
            }

            private ECPoint createPoint(long[] x, long[] y) {
                return SecT571K1Curve.this.createRawPoint(new SecT571FieldElement(x), new SecT571FieldElement(y), SECT571K1_AFFINE_ZS);
            }
        };
    }
}

