/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.oer.its.EccCurvePoint;
import net.savignano.thirdparty.org.bouncycastle.oer.its.EccP256CurvePoint;

public class BasePublicEncryptionKey
extends ASN1Object
implements ASN1Choice {
    public static final int eciesNistP256 = 0;
    public static final int eciesBrainpoolP256r1 = 1;
    public static final int extension = 2;
    private final int choice;
    private final ASN1Encodable value;

    public BasePublicEncryptionKey(int choice, ASN1Encodable value) {
        this.choice = choice;
        this.value = value;
    }

    public static BasePublicEncryptionKey getInstance(Object objectAt) {
        ASN1Object value;
        if (objectAt instanceof BasePublicEncryptionKey) {
            return (BasePublicEncryptionKey)objectAt;
        }
        ASN1TaggedObject dto = ASN1TaggedObject.getInstance(objectAt);
        switch (dto.getTagNo()) {
            case 0: 
            case 1: {
                value = EccP256CurvePoint.getInstance(dto.getObject());
                break;
            }
            case 2: {
                value = DEROctetString.getInstance(dto.getObject());
                break;
            }
            default: {
                throw new IllegalStateException("unknown choice " + dto.getTagNo());
            }
        }
        return new BasePublicEncryptionKey(dto.getTagNo(), value);
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getValue() {
        return this.value;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.value);
    }

    public static class Builder {
        private int choice;
        private ASN1Encodable value;

        public Builder setChoice(int choice) {
            this.choice = choice;
            return this;
        }

        public Builder setValue(EccCurvePoint value) {
            this.value = value;
            return this;
        }

        public BasePublicEncryptionKey createBasePublicEncryptionKey() {
            return new BasePublicEncryptionKey(this.choice, this.value);
        }
    }
}

