/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.oer.its.EccP384CurvePoint;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Utils;

public class EcdsaP384Signature
extends ASN1Object {
    private final EccP384CurvePoint rSig;
    private final ASN1OctetString sSig;

    public EcdsaP384Signature(EccP384CurvePoint rSig, ASN1OctetString sSig) {
        this.rSig = rSig;
        this.sSig = sSig;
    }

    public static EcdsaP384Signature getInstance(Object object) {
        ASN1Sequence it = ASN1Sequence.getInstance(object);
        return new Builder().setrSig(EccP384CurvePoint.getInstance(it.getObjectAt(0))).setsSig(ASN1OctetString.getInstance(it.getObjectAt(1))).createEcdsaP384Signature();
    }

    public EccP384CurvePoint getrSig() {
        return this.rSig;
    }

    public ASN1OctetString getsSig() {
        return this.sSig;
    }

    public ASN1Primitive toASN1Primitive() {
        return Utils.toSequence(this.rSig, this.sSig);
    }

    public static class Builder {
        private EccP384CurvePoint rSig;
        private ASN1OctetString sSig;

        public Builder setrSig(EccP384CurvePoint rSig) {
            this.rSig = rSig;
            return this;
        }

        public Builder setsSig(ASN1OctetString sSig) {
            this.sSig = sSig;
            return this;
        }

        public EcdsaP384Signature createEcdsaP384Signature() {
            return new EcdsaP384Signature(this.rSig, this.sSig);
        }
    }
}

