/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.oer.its.RegionInterface;
import net.savignano.thirdparty.org.bouncycastle.oer.its.TwoDLocation;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonalRegion
extends ASN1Object
implements RegionInterface {
    private final List<TwoDLocation> points;

    public PolygonalRegion(List<TwoDLocation> locations) {
        this.points = Collections.unmodifiableList(locations);
    }

    public static PolygonalRegion getInstance(Object o) {
        if (o instanceof PolygonalRegion) {
            return (PolygonalRegion)o;
        }
        if (o != null) {
            return new PolygonalRegion(Utils.fillList(TwoDLocation.class, ASN1Sequence.getInstance(o)));
        }
        return null;
    }

    public List<TwoDLocation> getPoints() {
        return this.points;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return Utils.toSequence(this.points);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private List<TwoDLocation> locations = new ArrayList<TwoDLocation>();

        public Builder setLocations(List<TwoDLocation> locations) {
            this.locations = locations;
            return this;
        }

        public Builder setLocations(TwoDLocation ... locations) {
            this.locations.addAll(Arrays.asList(locations));
            return this;
        }

        public PolygonalRegion createPolygonalRegion() {
            return new PolygonalRegion(this.locations);
        }
    }
}

