/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.oer.OEROptional;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Psid;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ServiceSpecificPermissions;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Utils;

public class PsidSsp
extends ASN1Object {
    private final Psid psid;
    private final ServiceSpecificPermissions ssp;

    public PsidSsp(Psid psid, ServiceSpecificPermissions ssp) {
        this.psid = psid;
        this.ssp = ssp;
    }

    public static PsidSsp getInstance(Object nextElement) {
        if (nextElement instanceof PsidSsp) {
            return (PsidSsp)nextElement;
        }
        ASN1Sequence seq = ASN1Sequence.getInstance(nextElement);
        return new PsidSsp(Psid.getInstance(seq.getObjectAt(0)), OEROptional.getValue(ServiceSpecificPermissions.class, seq.getObjectAt(1)));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Psid getPsid() {
        return this.psid;
    }

    public ServiceSpecificPermissions getSsp() {
        return this.ssp;
    }

    public ASN1Primitive toASN1Primitive() {
        return Utils.toSequence(this.psid, OEROptional.getInstance(this.ssp));
    }

    public static class Builder {
        private Psid psid;
        private ServiceSpecificPermissions ssp;

        public Builder setPsid(Psid psid) {
            this.psid = psid;
            return this;
        }

        public Builder setSsp(ServiceSpecificPermissions ssp) {
            this.ssp = ssp;
            return this;
        }

        public PsidSsp createPsidSsp() {
            return new PsidSsp(this.psid, this.ssp);
        }
    }
}

