/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPLiteralData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.StreamGenerator;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class PGPCanonicalizedDataGenerator
implements StreamGenerator {
    public static final char TEXT = 't';
    public static final char UTF8 = 'u';
    public static final String CONSOLE = "_CONSOLE";
    public static final Date NOW = PGPLiteralData.NOW;
    private PGPLiteralDataGenerator lGen;
    private boolean oldFormat = false;

    public PGPCanonicalizedDataGenerator() {
    }

    public PGPCanonicalizedDataGenerator(boolean oldFormat) {
        this.oldFormat = oldFormat;
    }

    public OutputStream open(OutputStream out, char format, String name, Date modificationTime) throws IOException {
        if (this.lGen != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.lGen = new PGPLiteralDataGenerator(this.oldFormat);
        return new ArrayCRLFGeneratorStream(out, this.lGen, format, name, new Date(modificationTime.getTime()));
    }

    public OutputStream open(OutputStream out, char format, String name, Date modificationTime, File backingFile) throws IOException {
        if (this.lGen != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.lGen = new PGPLiteralDataGenerator(this.oldFormat);
        return new FileCRLFGeneratorStream(out, this.lGen, format, name, new Date(modificationTime.getTime()), backingFile);
    }

    public OutputStream open(OutputStream out, char format, String name, Date modificationTime, byte[] buffer) throws IOException {
        if (this.lGen != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.lGen = new PGPLiteralDataGenerator(this.oldFormat);
        return new IndefiniteCRLFGeneratorStream(out, this.lGen, format, name, new Date(modificationTime.getTime()), buffer);
    }

    public OutputStream open(OutputStream out, char format, File file) throws IOException {
        return this.open(out, format, file.getName(), new Date(file.lastModified()));
    }

    public void close() throws IOException {
        if (this.lGen != null) {
            this.lGen.close();
            this.lGen = null;
        }
    }

    private static final class ErasableOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuf() {
            return this.buf;
        }

        public void erase() {
            Arrays.fill(this.buf, (byte)0);
            this.reset();
        }
    }

    private class ArrayCRLFGeneratorStream
    extends CRLFGeneratorStream {
        private final OutputStream out;
        private final PGPLiteralDataGenerator lGen;
        private final char format;
        private final String name;
        private final Date modificationTime;

        public ArrayCRLFGeneratorStream(OutputStream out, PGPLiteralDataGenerator sGen, char format, String name, Date modificationTime) {
            super(new ErasableOutputStream(), format == 'b');
            this.out = out;
            this.lGen = sGen;
            this.format = format;
            this.name = name;
            this.modificationTime = modificationTime;
        }

        public void close() throws IOException {
            super.close();
            ErasableOutputStream bOut = (ErasableOutputStream)this.crlfOut;
            byte[] buf = bOut.getBuf();
            int length = bOut.size();
            OutputStream lOut = this.lGen.open(this.out, this.format, this.name, length, this.modificationTime);
            lOut.write(buf, 0, length);
            lOut.close();
            bOut.erase();
        }
    }

    private class IndefiniteCRLFGeneratorStream
    extends CRLFGeneratorStream {
        public IndefiniteCRLFGeneratorStream(OutputStream out, PGPLiteralDataGenerator sGen, char format, String name, Date modificationTime, byte[] buffer) throws IOException {
            super(sGen.open(out, format, name, modificationTime, buffer), format == 'b');
        }

        public void close() throws IOException {
            super.close();
        }
    }

    private class FileCRLFGeneratorStream
    extends CRLFGeneratorStream {
        private final OutputStream out;
        private final PGPLiteralDataGenerator lGen;
        private final char format;
        private final String name;
        private final Date modificationTime;
        private final File backingFile;

        public FileCRLFGeneratorStream(OutputStream out, PGPLiteralDataGenerator sGen, char format, String name, Date modificationTime, File backingFile) throws FileNotFoundException {
            super(new BufferedOutputStream(new FileOutputStream(backingFile)), format == 'b');
            this.out = out;
            this.lGen = sGen;
            this.format = format;
            this.name = name;
            this.modificationTime = modificationTime;
            this.backingFile = backingFile;
        }

        public void close() throws IOException {
            super.close();
            OutputStream lOut = this.lGen.open(this.out, this.format, this.name, this.backingFile.length(), this.modificationTime);
            PGPUtil.pipeFileContents(this.backingFile, lOut, 32678);
        }
    }

    class CRLFGeneratorStream
    extends OutputStream {
        protected final OutputStream crlfOut;
        private final boolean isBinary;
        private int lastB = 0;

        public CRLFGeneratorStream(OutputStream crlfOut, boolean isBinary) {
            this.crlfOut = crlfOut;
            this.isBinary = isBinary;
        }

        public void write(int b) throws IOException {
            if (!this.isBinary) {
                if (b == 10 && this.lastB != 13) {
                    this.crlfOut.write(13);
                } else if (this.lastB == 13 && b != 10) {
                    this.crlfOut.write(10);
                }
                this.lastB = b;
            }
            this.crlfOut.write(b);
        }

        public void close() throws IOException {
            if (!this.isBinary && this.lastB == 13) {
                this.crlfOut.write(10);
            }
            this.crlfOut.close();
        }
    }
}

