/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ContainedPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.PublicKeyPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.PublicSubkeyPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SecretKeyPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SecretSubkeyPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.TrustPacket;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Iterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGPSecretKeyRing
extends PGPKeyRing
implements Iterable<PGPSecretKey> {
    List keys;
    List extraPubKeys;

    private static List checkKeys(List keys) {
        ArrayList<PGPSecretKey> rv = new ArrayList<PGPSecretKey>(keys.size());
        for (int i = 0; i != keys.size(); ++i) {
            PGPSecretKey k = (PGPSecretKey)keys.get(i);
            if (i == 0) {
                if (!k.isMasterKey()) {
                    throw new IllegalArgumentException("key 0 must be a master key");
                }
            } else if (k.isMasterKey()) {
                throw new IllegalArgumentException("key 0 can be only master key");
            }
            rv.add(k);
        }
        return rv;
    }

    public PGPSecretKeyRing(List<PGPSecretKey> secKeys) {
        this(PGPSecretKeyRing.checkKeys(secKeys), new ArrayList());
    }

    private PGPSecretKeyRing(List keys, List extraPubKeys) {
        this.keys = keys;
        this.extraPubKeys = extraPubKeys;
    }

    public PGPSecretKeyRing(byte[] encoding, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        this(new ByteArrayInputStream(encoding), fingerPrintCalculator);
    }

    public PGPSecretKeyRing(InputStream in, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        this.keys = new ArrayList();
        this.extraPubKeys = new ArrayList();
        BCPGInputStream pIn = PGPSecretKeyRing.wrap(in);
        int initialTag = pIn.skipMarkerPackets();
        if (initialTag != 5 && initialTag != 7) {
            throw new IOException("secret key ring doesn't start with secret key tag: tag 0x" + Integer.toHexString(initialTag));
        }
        SecretKeyPacket secret = (SecretKeyPacket)pIn.readPacket();
        while (pIn.nextPacketTag() == 61) {
            pIn.readPacket();
        }
        TrustPacket trust = PGPSecretKeyRing.readOptionalTrustPacket(pIn);
        List keySigs = PGPSecretKeyRing.readSignaturesAndTrust(pIn);
        ArrayList ids = new ArrayList();
        ArrayList idTrusts = new ArrayList();
        ArrayList idSigs = new ArrayList();
        PGPSecretKeyRing.readUserIDs(pIn, ids, idTrusts, idSigs);
        this.keys.add(new PGPSecretKey(secret, new PGPPublicKey(secret.getPublicKeyPacket(), trust, keySigs, ids, idTrusts, idSigs, fingerPrintCalculator)));
        while (pIn.nextPacketTag() == 7 || pIn.nextPacketTag() == 14) {
            List sigList;
            TrustPacket subTrust;
            ContainedPacket sub;
            if (pIn.nextPacketTag() == 7) {
                sub = (SecretSubkeyPacket)pIn.readPacket();
                while (pIn.nextPacketTag() == 61) {
                    pIn.readPacket();
                }
                subTrust = PGPSecretKeyRing.readOptionalTrustPacket(pIn);
                sigList = PGPSecretKeyRing.readSignaturesAndTrust(pIn);
                this.keys.add(new PGPSecretKey((SecretKeyPacket)sub, new PGPPublicKey(((SecretKeyPacket)sub).getPublicKeyPacket(), subTrust, sigList, fingerPrintCalculator)));
                continue;
            }
            sub = (PublicSubkeyPacket)pIn.readPacket();
            subTrust = PGPSecretKeyRing.readOptionalTrustPacket(pIn);
            sigList = PGPSecretKeyRing.readSignaturesAndTrust(pIn);
            this.extraPubKeys.add(new PGPPublicKey((PublicKeyPacket)sub, subTrust, sigList, fingerPrintCalculator));
        }
    }

    @Override
    public PGPPublicKey getPublicKey() {
        return ((PGPSecretKey)this.keys.get(0)).getPublicKey();
    }

    @Override
    public PGPPublicKey getPublicKey(long keyID) {
        PGPSecretKey key = this.getSecretKey(keyID);
        if (key != null) {
            return key.getPublicKey();
        }
        for (int i = 0; i != this.extraPubKeys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.extraPubKeys.get(i);
            if (keyID != k.getKeyID()) continue;
            return k;
        }
        return null;
    }

    @Override
    public PGPPublicKey getPublicKey(byte[] fingerprint) {
        PGPSecretKey key = this.getSecretKey(fingerprint);
        if (key != null) {
            return key.getPublicKey();
        }
        for (int i = 0; i != this.extraPubKeys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.extraPubKeys.get(i);
            if (!Arrays.areEqual(fingerprint, k.getFingerprint())) continue;
            return k;
        }
        return null;
    }

    @Override
    public Iterator<PGPPublicKey> getKeysWithSignaturesBy(long keyID) {
        ArrayList<PGPPublicKey> keysWithSigs = new ArrayList<PGPPublicKey>();
        Iterator<PGPPublicKey> keyIt = this.getPublicKeys();
        while (keyIt.hasNext()) {
            PGPPublicKey k = keyIt.next();
            Iterator<PGPSignature> sigIt = k.getSignaturesForKeyID(keyID);
            if (!sigIt.hasNext()) continue;
            keysWithSigs.add(k);
        }
        return keysWithSigs.iterator();
    }

    @Override
    public Iterator<PGPPublicKey> getPublicKeys() {
        ArrayList<PGPPublicKey> pubKeys = new ArrayList<PGPPublicKey>();
        Iterator<PGPSecretKey> it = this.getSecretKeys();
        while (it.hasNext()) {
            PGPPublicKey key = it.next().getPublicKey();
            pubKeys.add(key);
        }
        pubKeys.addAll(this.extraPubKeys);
        return Collections.unmodifiableList(pubKeys).iterator();
    }

    public PGPSecretKey getSecretKey() {
        return (PGPSecretKey)this.keys.get(0);
    }

    public Iterator<PGPSecretKey> getSecretKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public PGPSecretKey getSecretKey(long keyID) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey k = (PGPSecretKey)this.keys.get(i);
            if (keyID != k.getKeyID()) continue;
            return k;
        }
        return null;
    }

    public PGPSecretKey getSecretKey(byte[] fingerprint) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey k = (PGPSecretKey)this.keys.get(i);
            if (!Arrays.areEqual(fingerprint, k.getPublicKey().getFingerprint())) continue;
            return k;
        }
        return null;
    }

    public Iterator<PGPPublicKey> getExtraPublicKeys() {
        return this.extraPubKeys.iterator();
    }

    @Override
    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    @Override
    public void encode(OutputStream outStream) throws IOException {
        Object k;
        int i;
        for (i = 0; i != this.keys.size(); ++i) {
            k = (PGPSecretKey)this.keys.get(i);
            ((PGPSecretKey)k).encode(outStream);
        }
        for (i = 0; i != this.extraPubKeys.size(); ++i) {
            k = (PGPPublicKey)this.extraPubKeys.get(i);
            ((PGPPublicKey)k).encode(outStream);
        }
    }

    @Override
    public Iterator<PGPSecretKey> iterator() {
        return this.getSecretKeys();
    }

    public static PGPSecretKeyRing replacePublicKeys(PGPSecretKeyRing secretRing, PGPPublicKeyRing publicRing) {
        ArrayList<PGPSecretKey> newList = new ArrayList<PGPSecretKey>(secretRing.keys.size());
        for (PGPSecretKey sk : secretRing.keys) {
            PGPPublicKey pk = publicRing.getPublicKey(sk.getKeyID());
            newList.add(PGPSecretKey.replacePublicKey(sk, pk));
        }
        return new PGPSecretKeyRing(newList);
    }

    public static PGPSecretKeyRing copyWithNewPassword(PGPSecretKeyRing ring, PBESecretKeyDecryptor oldKeyDecryptor, PBESecretKeyEncryptor newKeyEncryptor) throws PGPException {
        ArrayList<PGPSecretKey> newKeys = new ArrayList<PGPSecretKey>(ring.keys.size());
        Iterator<PGPSecretKey> keys = ring.getSecretKeys();
        while (keys.hasNext()) {
            PGPSecretKey key = keys.next();
            if (key.isPrivateKeyEmpty()) {
                newKeys.add(key);
                continue;
            }
            newKeys.add(PGPSecretKey.copyWithNewPassword(key, oldKeyDecryptor, newKeyEncryptor));
        }
        return new PGPSecretKeyRing(newKeys, ring.extraPubKeys);
    }

    public static PGPSecretKeyRing insertSecretKey(PGPSecretKeyRing secRing, PGPSecretKey secKey) {
        ArrayList<PGPSecretKey> keys = new ArrayList<PGPSecretKey>(secRing.keys);
        boolean found = false;
        boolean masterFound = false;
        for (int i = 0; i != keys.size(); ++i) {
            PGPSecretKey key = (PGPSecretKey)keys.get(i);
            if (key.getKeyID() == secKey.getKeyID()) {
                found = true;
                keys.set(i, secKey);
            }
            if (!key.isMasterKey()) continue;
            masterFound = true;
        }
        if (!found) {
            if (secKey.isMasterKey()) {
                if (masterFound) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                keys.add(0, secKey);
            } else {
                keys.add(secKey);
            }
        }
        return new PGPSecretKeyRing(keys, secRing.extraPubKeys);
    }

    public static PGPSecretKeyRing removeSecretKey(PGPSecretKeyRing secRing, PGPSecretKey secKey) {
        ArrayList keys = new ArrayList(secRing.keys);
        boolean found = false;
        for (int i = 0; i < keys.size(); ++i) {
            PGPSecretKey key = (PGPSecretKey)keys.get(i);
            if (key.getKeyID() != secKey.getKeyID()) continue;
            found = true;
            keys.remove(i);
        }
        if (!found) {
            return null;
        }
        return new PGPSecretKeyRing(keys, secRing.extraPubKeys);
    }
}

