/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.X9ECParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.BlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.BufferedBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.ec.CustomNamedCurves;
import net.savignano.thirdparty.org.bouncycastle.crypto.io.CipherInputStream;
import net.savignano.thirdparty.org.bouncycastle.crypto.modes.CFBBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.modes.OpenPGPCFBBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.KeyParameter;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ParametersWithIV;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECCurve;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECPoint;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.util.BigIntegers;

class BcUtil {
    BcUtil() {
    }

    static BufferedBlockCipher createStreamCipher(boolean forEncryption, BlockCipher engine, boolean withIntegrityPacket, byte[] key) {
        BufferedBlockCipher c = withIntegrityPacket ? new BufferedBlockCipher(new CFBBlockCipher(engine, engine.getBlockSize() * 8)) : new BufferedBlockCipher(new OpenPGPCFBBlockCipher(engine));
        KeyParameter keyParameter = new KeyParameter(key);
        if (withIntegrityPacket) {
            c.init(forEncryption, new ParametersWithIV(keyParameter, new byte[engine.getBlockSize()]));
        } else {
            c.init(forEncryption, keyParameter);
        }
        return c;
    }

    public static PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, BlockCipher engine, byte[] key) {
        final BufferedBlockCipher c = BcUtil.createStreamCipher(false, engine, withIntegrityPacket, key);
        return new PGPDataDecryptor(){

            public InputStream getInputStream(InputStream in) {
                return new CipherInputStream(in, c);
            }

            public int getBlockSize() {
                return c.getBlockSize();
            }

            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    public static BufferedBlockCipher createSymmetricKeyWrapper(boolean forEncryption, BlockCipher engine, byte[] key, byte[] iv) {
        BufferedBlockCipher c = new BufferedBlockCipher(new CFBBlockCipher(engine, engine.getBlockSize() * 8));
        c.init(forEncryption, new ParametersWithIV(new KeyParameter(key), iv));
        return c;
    }

    static X9ECParameters getX9Parameters(ASN1ObjectIdentifier curveOID) {
        X9ECParameters x9 = CustomNamedCurves.getByOID(curveOID);
        if (x9 == null) {
            x9 = ECNamedCurveTable.getByOID(curveOID);
        }
        return x9;
    }

    static ECPoint decodePoint(BigInteger encodedPoint, ECCurve curve) throws IOException {
        return curve.decodePoint(BigIntegers.asUnsignedByteArray(encodedPoint));
    }
}

