/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import net.savignano.thirdparty.org.bouncycastle.jcajce.io.OutputStreamFactory;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPRuntimeOperationException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentVerifier;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcaPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private JcaPGPDigestCalculatorProviderBuilder digestCalculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcaPGPContentVerifierBuilderProvider setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        this.digestCalculatorProviderBuilder.setProvider(provider);
        return this;
    }

    public JcaPGPContentVerifierBuilderProvider setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        this.keyConverter.setProvider(providerName);
        this.digestCalculatorProviderBuilder.setProvider(providerName);
        return this;
    }

    public PGPContentVerifierBuilder get(int keyAlgorithm, int hashAlgorithm) throws PGPException {
        return new JcaPGPContentVerifierBuilder(keyAlgorithm, hashAlgorithm);
    }

    private class JcaPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public JcaPGPContentVerifierBuilder(int keyAlgorithm, int hashAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            this.hashAlgorithm = hashAlgorithm;
        }

        public PGPContentVerifier build(final PGPPublicKey publicKey) throws PGPException {
            final Signature signature = JcaPGPContentVerifierBuilderProvider.this.helper.createSignature(this.keyAlgorithm, this.hashAlgorithm);
            final PGPDigestCalculator digestCalculator = JcaPGPContentVerifierBuilderProvider.this.digestCalculatorProviderBuilder.build().get(this.hashAlgorithm);
            final PublicKey jcaKey = JcaPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(publicKey);
            try {
                signature.initVerify(jcaKey);
            }
            catch (InvalidKeyException e) {
                throw new PGPException("invalid key.", e);
            }
            return new PGPContentVerifier(){

                public int getHashAlgorithm() {
                    return JcaPGPContentVerifierBuilder.this.hashAlgorithm;
                }

                public int getKeyAlgorithm() {
                    return JcaPGPContentVerifierBuilder.this.keyAlgorithm;
                }

                public long getKeyID() {
                    return publicKey.getKeyID();
                }

                public boolean verify(byte[] expected) {
                    try {
                        int modLength;
                        if (jcaKey instanceof RSAPublicKey && expected.length < (modLength = (((RSAPublicKey)jcaKey).getModulus().bitLength() + 7) / 8)) {
                            byte[] tmp = new byte[modLength];
                            System.arraycopy(expected, 0, tmp, tmp.length - expected.length, expected.length);
                            return signature.verify(tmp);
                        }
                        if (JcaPGPContentVerifierBuilder.this.keyAlgorithm == 22) {
                            signature.update(digestCalculator.getDigest());
                            return signature.verify(expected);
                        }
                        return signature.verify(expected);
                    }
                    catch (SignatureException e) {
                        throw new PGPRuntimeOperationException("unable to verify signature: " + e.getMessage(), e);
                    }
                }

                public OutputStream getOutputStream() {
                    if (JcaPGPContentVerifierBuilder.this.keyAlgorithm == 22) {
                        return digestCalculator.getOutputStream();
                    }
                    return OutputStreamFactory.createStream(signature);
                }
            };
        }
    }
}

