/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.qtesla;

import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public final class QTESLAPrivateKeyParameters
extends AsymmetricKeyParameter {
    private int securityCategory;
    private byte[] privateKey;

    public QTESLAPrivateKeyParameters(int securityCategory, byte[] privateKey) {
        super(true);
        if (privateKey.length != QTESLASecurityCategory.getPrivateSize(securityCategory)) {
            throw new IllegalArgumentException("invalid key size for security category");
        }
        this.securityCategory = securityCategory;
        this.privateKey = Arrays.clone(privateKey);
    }

    public int getSecurityCategory() {
        return this.securityCategory;
    }

    public byte[] getSecret() {
        return Arrays.clone(this.privateKey);
    }
}

