/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus;

import java.util.LinkedList;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.ADRS;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.NodeEntry;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.SIG_XMSS;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusEngine;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.WotsPlus;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

class HT {
    private final byte[] skSeed;
    private final byte[] pkSeed;
    SPHINCSPlusEngine engine;
    WotsPlus wots;
    final byte[] htPubKey;

    public HT(SPHINCSPlusEngine engine, byte[] skSeed, byte[] pkSeed) {
        this.skSeed = skSeed;
        this.pkSeed = pkSeed;
        this.engine = engine;
        this.wots = new WotsPlus(engine);
        ADRS adrs = new ADRS();
        adrs.setLayerAddress(engine.D - 1);
        adrs.setTreeAddress(0L);
        this.htPubKey = (byte[])(skSeed != null ? this.xmss_PKgen(skSeed, pkSeed, adrs) : null);
    }

    byte[] sign(byte[] M, long idx_tree, int idx_leaf) {
        ADRS adrs = new ADRS();
        adrs.setLayerAddress(0);
        adrs.setTreeAddress(idx_tree);
        SIG_XMSS SIG_tmp = this.xmss_sign(M, this.skSeed, idx_leaf, this.pkSeed, adrs);
        SIG_XMSS[] SIG_HT = new SIG_XMSS[this.engine.D];
        SIG_HT[0] = SIG_tmp;
        adrs.setLayerAddress(0);
        adrs.setTreeAddress(idx_tree);
        byte[] root = this.xmss_pkFromSig(idx_leaf, SIG_tmp, M, this.pkSeed, adrs);
        for (int j = 1; j < this.engine.D; ++j) {
            idx_leaf = (int)(idx_tree & (long)((1 << this.engine.H_PRIME) - 1));
            adrs.setLayerAddress(j);
            adrs.setTreeAddress(idx_tree >>>= this.engine.H_PRIME);
            SIG_HT[j] = SIG_tmp = this.xmss_sign(root, this.skSeed, idx_leaf, this.pkSeed, adrs);
            if (j >= this.engine.D - 1) continue;
            root = this.xmss_pkFromSig(idx_leaf, SIG_tmp, root, this.pkSeed, adrs);
        }
        byte[][] totSigs = new byte[SIG_HT.length][];
        for (int i = 0; i != totSigs.length; ++i) {
            totSigs[i] = Arrays.concatenate(SIG_HT[i].sig, Arrays.concatenate(SIG_HT[i].auth));
        }
        return Arrays.concatenate(totSigs);
    }

    byte[] xmss_PKgen(byte[] skSeed, byte[] pkSeed, ADRS adrs) {
        return this.treehash(skSeed, 0, this.engine.H_PRIME, pkSeed, adrs);
    }

    byte[] xmss_pkFromSig(int idx, SIG_XMSS sig_xmss, byte[] M, byte[] pkSeed, ADRS paramAdrs) {
        ADRS adrs = new ADRS(paramAdrs);
        adrs.setType(0);
        adrs.setKeyPairAddress(idx);
        byte[] sig = sig_xmss.getWOTSSig();
        byte[][] AUTH = sig_xmss.getXMSSAUTH();
        byte[] node0 = this.wots.pkFromSig(sig, M, pkSeed, adrs);
        byte[] node1 = null;
        adrs.setType(2);
        adrs.setTreeIndex(idx);
        for (int k = 0; k < this.engine.H_PRIME; ++k) {
            adrs.setTreeHeight(k + 1);
            if (idx / (1 << k) % 2 == 0) {
                adrs.setTreeIndex(adrs.getTreeIndex() / 2);
                node1 = this.engine.H(pkSeed, adrs, node0, AUTH[k]);
            } else {
                adrs.setTreeIndex((adrs.getTreeIndex() - 1) / 2);
                node1 = this.engine.H(pkSeed, adrs, AUTH[k], node0);
            }
            node0 = node1;
        }
        return node0;
    }

    SIG_XMSS xmss_sign(byte[] M, byte[] skSeed, int idx, byte[] pkSeed, ADRS adrs) {
        byte[][] AUTH = new byte[this.engine.H_PRIME][];
        for (int j = 0; j < this.engine.H_PRIME; ++j) {
            int k = idx / (1 << j) ^ 1;
            AUTH[j] = this.treehash(skSeed, k * (1 << j), j, pkSeed, adrs);
        }
        adrs = new ADRS(adrs);
        adrs.setType(0);
        adrs.setKeyPairAddress(idx);
        byte[] sig = this.wots.sign(M, skSeed, pkSeed, adrs);
        return new SIG_XMSS(sig, AUTH);
    }

    byte[] treehash(byte[] skSeed, int s, int z, byte[] pkSeed, ADRS adrsParam) {
        ADRS adrs = new ADRS(adrsParam);
        LinkedList<NodeEntry> stack = new LinkedList<NodeEntry>();
        if (s % (1 << z) != 0) {
            return null;
        }
        for (int idx = 0; idx < 1 << z; ++idx) {
            adrs.setType(0);
            adrs.setKeyPairAddress(s + idx);
            byte[] node = this.wots.pkGen(skSeed, pkSeed, adrs);
            adrs.setType(2);
            adrs.setTreeHeight(1);
            adrs.setTreeIndex(s + idx);
            while (!stack.isEmpty() && ((NodeEntry)stack.get((int)0)).nodeHeight == adrs.getTreeHeight()) {
                adrs.setTreeIndex((adrs.getTreeIndex() - 1) / 2);
                NodeEntry current = (NodeEntry)stack.remove(0);
                node = this.engine.H(pkSeed, adrs, current.nodeValue, node);
                adrs.setTreeHeight(adrs.getTreeHeight() + 1);
            }
            stack.add(0, new NodeEntry(node, adrs.getTreeHeight()));
        }
        return ((NodeEntry)stack.get((int)0)).nodeValue;
    }

    public boolean verify(byte[] M, SIG_XMSS[] sig_ht, byte[] pkSeed, long idx_tree, int idx_leaf, byte[] PK_HT) {
        ADRS adrs = new ADRS();
        SIG_XMSS SIG_tmp = sig_ht[0];
        adrs.setLayerAddress(0);
        adrs.setTreeAddress(idx_tree);
        byte[] node = this.xmss_pkFromSig(idx_leaf, SIG_tmp, M, pkSeed, adrs);
        for (int j = 1; j < this.engine.D; ++j) {
            idx_leaf = (int)(idx_tree & (long)((1 << this.engine.H_PRIME) - 1));
            SIG_tmp = sig_ht[j];
            adrs.setLayerAddress(j);
            adrs.setTreeAddress(idx_tree >>>= this.engine.H_PRIME);
            node = this.xmss_pkFromSig(idx_leaf, SIG_tmp, node, pkSeed, adrs);
        }
        return Arrays.areEqual(PK_HT, node);
    }
}

