/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc;

import net.savignano.thirdparty.org.bouncycastle.crypto.digests.NullDigest;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.signers.DSADigestSigner;
import net.savignano.thirdparty.org.bouncycastle.crypto.signers.ECDSASigner;
import net.savignano.thirdparty.org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import net.savignano.thirdparty.org.bouncycastle.tls.DigitallySigned;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureScheme;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public class BcTlsECDSA13Verifier
extends BcTlsVerifier {
    private final int signatureScheme;

    public BcTlsECDSA13Verifier(BcTlsCrypto crypto, ECPublicKeyParameters publicKey, int signatureScheme) {
        super(crypto, publicKey);
        if (!SignatureScheme.isECDSA(signatureScheme)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.signatureScheme = signatureScheme;
    }

    public boolean verifyRawSignature(DigitallySigned signature, byte[] hash) {
        SignatureAndHashAlgorithm algorithm = signature.getAlgorithm();
        if (algorithm == null || SignatureScheme.from(algorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(this.signatureScheme);
        ECDSASigner dsa = new ECDSASigner(new HMacDSAKCalculator(this.crypto.createDigest(cryptoHashAlgorithm)));
        DSADigestSigner signer = new DSADigestSigner(dsa, new NullDigest());
        signer.init(false, this.publicKey);
        signer.update(hash, 0, hash.length);
        return signer.verifySignature(signature.getSignature());
    }
}

