/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.engines.RSAEngine;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.RSAKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.signers.PSSSigner;
import net.savignano.thirdparty.org.bouncycastle.tls.DigitallySigned;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureScheme;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsStreamVerifier;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsStreamVerifier;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public class BcTlsRSAPSSVerifier
extends BcTlsVerifier {
    private final int signatureScheme;

    public BcTlsRSAPSSVerifier(BcTlsCrypto crypto, RSAKeyParameters publicKey, int signatureScheme) {
        super(crypto, publicKey);
        if (!SignatureScheme.isRSAPSS(signatureScheme)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.signatureScheme = signatureScheme;
    }

    public boolean verifyRawSignature(DigitallySigned signature, byte[] hash) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) {
        SignatureAndHashAlgorithm algorithm = signature.getAlgorithm();
        if (algorithm == null || SignatureScheme.from(algorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(this.signatureScheme);
        Digest digest = this.crypto.createDigest(cryptoHashAlgorithm);
        PSSSigner verifier = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), digest, digest.getDigestSize());
        verifier.init(false, this.publicKey);
        return new BcTlsStreamVerifier(verifier, signature.getSignature());
    }
}

