/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoException;
import net.savignano.thirdparty.org.bouncycastle.crypto.Signer;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.NullDigest;
import net.savignano.thirdparty.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import net.savignano.thirdparty.org.bouncycastle.crypto.engines.RSABlindedEngine;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ParametersWithRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.RSAKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.signers.GenericSigner;
import net.savignano.thirdparty.org.bouncycastle.crypto.signers.RSADigestSigner;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsUtils;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;

public class BcTlsRSASigner
extends BcTlsSigner {
    private final RSAKeyParameters publicKey;

    public BcTlsRSASigner(BcTlsCrypto crypto, RSAKeyParameters privateKey, RSAKeyParameters publicKey) {
        super(crypto, privateKey);
        this.publicKey = publicKey;
    }

    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        Signer signer;
        NullDigest nullDigest = new NullDigest();
        if (algorithm != null) {
            if (algorithm.getSignature() != 1) {
                throw new IllegalStateException("Invalid algorithm: " + algorithm);
            }
            signer = new RSADigestSigner(nullDigest, TlsUtils.getOIDForHashAlgorithm(algorithm.getHash()));
        } else {
            signer = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), nullDigest);
        }
        signer.init(true, new ParametersWithRandom(this.privateKey, this.crypto.getSecureRandom()));
        signer.update(hash, 0, hash.length);
        try {
            byte[] signature = signer.generateSignature();
            signer.init(false, this.publicKey);
            signer.update(hash, 0, hash.length);
            if (signer.verifySignature(signature)) {
                return signature;
            }
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        throw new TlsFatalAlert(80);
    }
}

