/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.util.io.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.util.io.BufferingOutputStream;
import net.savignano.thirdparty.org.bouncycastle.util.test.SimpleTest;

public class BufferingOutputStreamTest
extends SimpleTest {
    public String getName() {
        return "BufferingStreamTest";
    }

    public void performTest() throws Exception {
        SecureRandom random = new SecureRandom();
        for (int i = 1; i != 256; ++i) {
            byte[] data = new byte[i];
            random.nextBytes(data);
            this.checkStream(data, 16);
            this.checkStream(data, 33);
            this.checkStream(data, 128);
        }
    }

    private void checkStream(byte[] data, int bufsize) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BufferingOutputStream bfOut = new BufferingOutputStream(bOut, bufsize);
        for (int i = 0; i != 10; ++i) {
            bfOut.write(data[0]);
            bfOut.write(data, 1, data.length - 1);
        }
        bfOut.close();
        byte[] output = bOut.toByteArray();
        for (int i = 0; i != 10; ++i) {
            for (int j = 0; j != data.length; ++j) {
                if (output[i * data.length + j] == data[j]) continue;
                this.fail("data mismatch!");
            }
        }
    }

    public static void main(String[] args) {
        BufferingOutputStreamTest.runTest(new BufferingOutputStreamTest());
    }
}

