/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.validate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.enums.EValidationType;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.mailer.validate.AMailValidator;
import net.savignano.snotify.atlassian.mailer.visitor.BaseMessageVisitor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpMailValidator
extends AMailValidator<SnotifyPgpPublicKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpMailValidator.class);
    private Function<String, SnotifyPgpPublicKey> publicKeyRetriever;
    private boolean checkInline;

    public static final boolean isMessageSigned(Message message) {
        if (!(message instanceof MimeMessage)) {
            log.debug("Message is not a MIME message, so can't be PGP signed. Encountered message class: {}", message.getClass());
            return false;
        }
        return PgpMailValidator.isSigned((MimePart)message);
    }

    private static final boolean isSigned(MimePart part) {
        try {
            ContentType type = new ContentType(part.getContentType());
            if (type.match("multipart/signed")) {
                String protocol = type.getParameter("protocol");
                return protocol != null && protocol.equalsIgnoreCase("application/pgp-signature");
            }
        }
        catch (MessagingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static final boolean isMessageSignedInline(Message message) {
        if (!(message instanceof MimeMessage)) {
            log.debug("Message is not a MIME message, so can't be PGP signed. Encountered message class: {}", message.getClass());
            return false;
        }
        final boolean[] signed = new boolean[1];
        BaseMessageVisitor visitor = new BaseMessageVisitor(){

            @Override
            public void visit(MimePart part) throws Exception {
                if (signed[0]) {
                    return;
                }
                if (part.isMimeType("text/plain")) {
                    Object content = part.getContent();
                    signed[0] = content instanceof String && ((String)content).startsWith("-----BEGIN PGP SIGNED MESSAGE-----");
                } else {
                    super.visit(part);
                }
            }
        };
        try {
            visitor.visit((MimeMessage)message);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return signed[0];
    }

    @Override
    public Set<EValidationType> getValidationCapability() {
        return EnumSet.of(EValidationType.CAN_VALIDATE, EValidationType.SIGNATURE);
    }

    @Override
    protected SnotifyPgpPublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifyPgpPublicKey(validity, EKeySource.EMAIL);
    }

    @Override
    protected boolean isSigned(MimeMessage msg) {
        return PgpMailValidator.isMessageSigned((Message)msg) || this.isCheckInline() && PgpMailValidator.isMessageSignedInline((Message)msg);
    }

    @Override
    protected boolean validate(MimeMessage msg, Set<EValidationType> validations, String email) throws Exception {
        SnotifyPgpPublicKey publicKey = this.getPublicKeyRetriever().apply(email);
        ValidateVisitor visitor = new ValidateVisitor(validations, email, publicKey.isValid() ? publicKey.getKeyRing() : null, this.isCheckInline());
        visitor.visit(msg);
        return visitor.isValid();
    }

    @Override
    protected SnotifyPgpPublicKey extract(MimeMessage msg, String email) throws Exception {
        ExtractVisitor visitor = new ExtractVisitor(email);
        visitor.visit(msg);
        PGPPublicKeyRing ring = visitor.getKeyRing();
        if (ring == null) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        SnotifyPgpPublicKey key = new SnotifyPgpPublicKey(ring, email);
        key.setKeySource(EKeySource.EMAIL);
        return key;
    }

    public Function<String, SnotifyPgpPublicKey> getPublicKeyRetriever() {
        return this.publicKeyRetriever == null ? s -> new SnotifyPgpPublicKey(EKeyValidity.NOT_FOUND) : this.publicKeyRetriever;
    }

    public void setPublicKeyRetriever(Function<String, SnotifyPgpPublicKey> publicKeyRetriever) {
        this.publicKeyRetriever = publicKeyRetriever;
    }

    public boolean isCheckInline() {
        return this.checkInline;
    }

    public void setCheckInline(boolean checkInline) {
        this.checkInline = checkInline;
    }

    private static final class ExtractVisitor
    extends BaseMessageVisitor {
        private final String email;
        private PGPPublicKeyRing ring;

        public ExtractVisitor(String email) {
            this.email = email;
        }

        @Override
        public void visit(MimePart part) throws Exception {
            super.visit(part);
            ContentType type = new ContentType(part.getContentType());
            log.trace("MIME type: {}", (Object)type);
            if (type.match("application/pgp-keys") || this.isKeyAttachment(part)) {
                log.debug("Extracting public key for email: {}", (Object)this.email);
                PGPPublicKeyRingCollection keys = PgpUtil.loadPublicKeys(part.getInputStream());
                this.ring = PgpUtil.getKeysForEmail(keys, this.email);
            }
        }

        private boolean isKeyAttachment(MimePart part) throws MessagingException {
            String fileName;
            String disposition = part.getDisposition();
            return disposition != null && disposition.equalsIgnoreCase("attachment") && (fileName = part.getFileName()) != null && fileName.endsWith(".asc") && !part.isMimeType("application/pgp-encrypted") && !part.isMimeType("application/pgp-signature");
        }

        public PGPPublicKeyRing getKeyRing() {
            return this.ring;
        }
    }

    private static final class ValidateVisitor
    extends BaseMessageVisitor {
        private final Set<EValidationType> validations;
        private final String email;
        private final boolean checkInline;
        private PGPPublicKeyRing ring;
        private boolean valid = false;

        public ValidateVisitor(Set<EValidationType> validations, String email, PGPPublicKeyRing ring, boolean checkInline) {
            this.validations = validations;
            this.email = email;
            this.ring = ring;
            this.checkInline = checkInline;
        }

        @Override
        public void visit(MimeMessage msg) throws Exception {
            log.debug("Validation types desired: {}", this.validations);
            if (this.ring == null) {
                ExtractVisitor extractVisitor = new ExtractVisitor(this.email);
                extractVisitor.visit(msg);
                this.ring = extractVisitor.getKeyRing();
            }
            if (this.validations.contains((Object)EValidationType.CAN_VALIDATE) && this.validations.size() == 1) {
                this.valid = this.ring != null;
            } else if (this.ring == null) {
                log.warn("Cannot verify PGP signature, as no public key was available.");
            } else {
                super.visit(msg);
            }
        }

        @Override
        public void visit(MimeMultipart multi) throws Exception {
            if (this.validations.contains((Object)EValidationType.SIGNATURE)) {
                ContentType type = new ContentType(multi.getContentType());
                log.trace("MIME type: {}", (Object)type);
                if (type.match("multipart/signed") && "application/pgp-signature".equalsIgnoreCase(type.getParameter("protocol"))) {
                    log.debug("Found '{}' content.", (Object)type);
                    this.valid = this.sanityCheck(multi) ? this.validate(multi) : false;
                }
            }
            super.visit(multi);
        }

        @Override
        public void visit(MimePart part) throws Exception {
            Object content;
            if (this.checkInline && this.validations.contains((Object)EValidationType.SIGNATURE) && part.isMimeType("text/plain") && (content = part.getContent()) instanceof String && ((String)content).startsWith("-----BEGIN PGP SIGNED MESSAGE-----")) {
                this.valid = this.validate(part);
            }
            super.visit(part);
        }

        private boolean sanityCheck(MimeMultipart mp) throws MessagingException {
            if (mp.getCount() != 2) {
                log.warn("PGP signature does not have expected part count. Two expected, but found: {}", (Object)mp.getCount());
                return false;
            }
            if (!mp.getBodyPart(1).isMimeType("application/pgp-signature")) {
                log.warn("PGP signature does not have expected content type. Found: {}", (Object)mp.getBodyPart(1).getContentType());
                return false;
            }
            log.debug("Sanity check of PGP signature successful.");
            return true;
        }

        private boolean validate(MimeMultipart mp) throws Exception {
            log.debug("Validating message.");
            MimeBodyPart contentPart = (MimeBodyPart)mp.getBodyPart(0);
            MimeBodyPart sigPart = (MimeBodyPart)mp.getBodyPart(1);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            contentPart.writeTo((OutputStream)os);
            byte[] contentBytes = os.toByteArray();
            os.reset();
            sigPart.writeTo((OutputStream)os);
            byte[] sigBytes = os.toByteArray();
            return PgpUtil.verify(contentBytes, sigBytes, this.ring.getPublicKey());
        }

        private boolean validate(MimePart part) throws Exception {
            log.debug("Validating inline message.");
            String fullContent = (String)part.getContent();
            String signature = this.getSignature(fullContent);
            String text = this.getTextRemoveHeaders(fullContent);
            if (PgpUtil.verify(text.getBytes(), signature.getBytes(), this.ring.getPublicKey())) {
                return true;
            }
            String plainText = this.getText(fullContent);
            return PgpUtil.verify(plainText.getBytes(), signature.getBytes(), this.ring.getPublicKey());
        }

        private String getText(String fullContent) {
            int startIndex = "-----BEGIN PGP SIGNED MESSAGE-----".length();
            int endIndex = fullContent.indexOf("-----BEGIN PGP SIGNATURE-----");
            String cropped = fullContent.substring(startIndex, endIndex);
            return this.removeLinebreaks(cropped);
        }

        private String getTextRemoveHeaders(String fullContent) throws MessagingException, IOException {
            StringBuilder builder = new StringBuilder(fullContent.length());
            ContentType contentType = new ContentType("text/plain");
            contentType.setParameter("charset", "UTF-8");
            builder.append("Content-Type");
            builder.append(": ");
            builder.append(contentType.toString());
            builder.append("\r\n");
            builder.append(this.getText(fullContent));
            MimeBodyPart part = new MimeBodyPart((InputStream)new ByteArrayInputStream(builder.toString().getBytes(Constants.UTF8_CHARSET)));
            return (String)part.getContent();
        }

        private String getSignature(String fullContent) {
            int startSig = fullContent.indexOf("-----BEGIN PGP SIGNATURE-----");
            return fullContent.substring(startSig);
        }

        private String removeLinebreaks(String str) {
            if (str == null || str.length() == 0) {
                return str;
            }
            int start = str.startsWith("\r\n") ? 2 : (str.charAt(0) == '\r' || str.charAt(0) == '\n' ? 1 : 0);
            int end = str.endsWith("\r\n") ? str.length() - 2 : (str.charAt(str.length() - 1) == '\r' || str.charAt(str.length() - 1) == '\n' ? str.length() - 1 : str.length());
            return str.substring(start, end);
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

