/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.common;

import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsBuilder;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.google.common.base.Function;
import io.atlassian.fugue.Option;
import javax.inject.Inject;
import net.savignano.snotify.atlassian.common.ASnotifyUserProperties;
import net.savignano.snotify.atlassian.common.IUser;
import net.savignano.snotify.bitbucket.common.BitbucketUser;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BitbucketComponent
public class SnotifyUserProperties
extends ASnotifyUserProperties {
    private static final Logger log = LoggerFactory.getLogger(SnotifyUserProperties.class);
    @Inject
    @ComponentImport
    private UserSettingsService userSettingsService;
    @Inject
    @ComponentImport
    private SecurityService securityService;

    @Override
    protected String getString(String key, IUser<?> user) {
        Option<String> value;
        try {
            value = this.getProps(user, key);
        }
        catch (Exception e) {
            log.error("Property exception loading user property " + key + ".", (Throwable)e);
            return null;
        }
        if (value.isEmpty() || StringUtils.isBlank((String)((String)value.get()))) {
            log.trace("User property \"{}\" for {} is considered null.", (Object)key, user);
            return null;
        }
        log.trace("User property \"{}\" for {} is: {}", new Object[]{key, user, value.get()});
        return (String)value.get();
    }

    @Override
    protected void setString(String key, String value, IUser<?> user) {
        try {
            log.trace("Setting user property \"{}\" for {} to: {}", new Object[]{key, user, value});
            if (value == null) {
                this.updateProps(user, (Function<UserSettingsBuilder, UserSettings>)((Function)b -> b.remove(key).build()));
            } else {
                this.updateProps(user, (Function<UserSettingsBuilder, UserSettings>)((Function)b -> b.put(key, value).build()));
            }
            if (log.isTraceEnabled()) {
                Option<String> newValue = this.getProps(user, key);
                if (value == null ? newValue.isDefined() : !value.equals(newValue.getOrNull())) {
                    log.error("Setting of user property \"{}\" for {} failed. Expected value: \"{}\". Actual value: \"{}\"", new Object[]{key, user, value, newValue});
                }
            }
        }
        catch (Exception e) {
            log.error("Property exception setting user property " + key + ".", (Throwable)e);
        }
    }

    private UserSettingsService getUserSettingsService() {
        if (this.userSettingsService == null) {
            log.trace("Injection of UserSettingsService failed. Loading manually.");
            this.userSettingsService = (UserSettingsService)ComponentLocator.getComponent(UserSettingsService.class);
        }
        return this.userSettingsService;
    }

    private SecurityService getSecurityService() {
        if (this.securityService == null) {
            log.trace("Injection of SecurityService failed. Loading manually.");
            this.securityService = (SecurityService)ComponentLocator.getComponent(SecurityService.class);
        }
        return this.securityService;
    }

    private Option<String> getProps(IUser<?> user, String key) {
        BitbucketUser bbUser = this.toBitbucketUser(user);
        EscalatedSecurityContext context = this.getSecurityService().impersonating(bbUser.getActualUser(), "Setting user properties for: " + bbUser);
        UserKey userKey = this.getUserKey(bbUser);
        UncheckedOperation operation = () -> this.getUserSettingsService().getUserSettings(userKey).getString(key);
        return (Option)context.call((Operation)operation);
    }

    private void updateProps(IUser<?> user, Function<UserSettingsBuilder, UserSettings> update) {
        BitbucketUser bbUser = this.toBitbucketUser(user);
        EscalatedSecurityContext context = this.getSecurityService().impersonating(bbUser.getActualUser(), "Setting user properties for: " + bbUser);
        UserKey userKey = this.getUserKey(bbUser);
        UncheckedOperation operation = () -> {
            this.getUserSettingsService().updateUserSettings(userKey, update);
            return null;
        };
        context.call((Operation)operation);
    }

    private UserKey getUserKey(BitbucketUser user) {
        return UserKey.fromLong((long)user.getActualUser().getId());
    }

    private BitbucketUser toBitbucketUser(IUser<?> user) {
        if (user == null) {
            throw new IllegalArgumentException("Can't get user preferences for 'null' user.");
        }
        if (!(user instanceof BitbucketUser)) {
            throw new IllegalArgumentException("User is not a BitbucketUser. Found instead: " + user);
        }
        return (BitbucketUser)user;
    }
}

