/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.cmc.test;

import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.CertificationRequest;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.encoders.Base64;
import net.savignano.thirdparty.org.bouncycastle.util.test.SimpleTest;

public class CMCCertificationRequestTest
extends SimpleTest {
    byte[] req1 = Base64.decode("MIHoMIGTAgEAMC4xDjAMBgNVBAMTBVRlc3QyMQ8wDQYDVQQKEwZBbmFUb20xCzAJBgNVBAYTAlNFMFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBALlEt31Tzt2MlcOljvacJgzQVhmlMoqAOgqJ9Pgd3GuxZ7/WcIlgW4QCB7WZT21O1YoghwBhPDMcNGrHei9kHQkCAwEAAaAAMA0GCSqGSIb3DQEBBQUAA0EANDEI4ecNtJ3uHwGGlitNFq9WxcoZ0djbQJ5hABMotav6gtqlrwKXY2evaIrsNwkJtNdwwH18aQDUKCjOuBL38Q==");
    byte[] req2 = Base64.decode("MIIB6TCCAVICAQAwgagxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlhMRQwEgYDVQQHEwtTYW50YSBDbGFyYTEMMAoGA1UEChMDQUJCMVEwTwYDVQQLHEhQAAAAAAAAAG8AAAAAAAAAdwAAAAAAAABlAAAAAAAAAHIAAAAAAAAAIAAAAAAAAABUAAAAAAAAABxIAAAAAAAARAAAAAAAAAAxDTALBgNVBAMTBGJsdWUwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBANETRZ+6occCOrFxNhfKIp4CmMkxwhBNb7TnnahpbM9O0r4hrBPcfYuL7u9YX/jN0YNUP+/CiT39HhSe/bikaBPDEyNsl988I8vXpiEdgxYq/+LTgGHbjRsRYCkPtmzwBbuBldNF8bV7pu0v4UScSsExmGqqDlX1TbPU8KkPU1iTAgMBAAGgADANBgkqhkiG9w0BAQQFAAOBgQAFbrs9qUwh93CtETk7DeUD5HcdCnxauo1bck44snSV6MZVOCIGaYu1501kmhEvAtVVRr6SEHwimfQDDIjnrWwYsEr/DT6tkTZAbfRd3qUu3iKjT0H0vlUZp0hJ66mINtBM84uZFBfoXiWY8M3FuAnGmvy6ah/dYtJorTxLKiGkew==");

    public String getName() {
        return "CMCCertificationRequestTest";
    }

    public void certReqTest(String testName, byte[] req) throws Exception {
        CertificationRequest r = CertificationRequest.getInstance(req);
        byte[] bytes = r.getEncoded("DER");
        if (bytes.length != req.length) {
            this.fail(testName + " failed length test");
        }
        for (int i = 0; i != req.length; ++i) {
            if (bytes[i] == req[i]) continue;
            this.fail(testName + " failed comparison test");
        }
    }

    public void performTest() throws Exception {
        this.certReqTest("req1", this.req1);
        this.certReqTest("req2", this.req2);
        CertificationRequest a = CertificationRequest.getInstance(this.req1);
        CertificationRequest b = new CertificationRequest(a.getSubject(), a.getSubjectPublicKeyAlgorithm(), a.getSubjectPublicKey(), a.getAttributes(), a.getSignatureAlgorithm(), a.getSignature());
        this.isTrue(Arrays.areEqual(a.getEncoded(), b.getEncoded()));
    }

    public static void main(String[] args) {
        CMCCertificationRequestTest.runTest(new CMCCertificationRequestTest());
    }
}

