/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.esf.test;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1InputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.esf.CommitmentTypeIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.esf.CommitmentTypeIndication;
import net.savignano.thirdparty.org.bouncycastle.util.test.SimpleTest;

public class CommitmentTypeIndicationUnitTest
extends SimpleTest {
    public String getName() {
        return "CommitmentTypeIndication";
    }

    public void performTest() throws Exception {
        CommitmentTypeIndication cti = new CommitmentTypeIndication(CommitmentTypeIdentifier.proofOfOrigin);
        this.checkConstruction(cti, CommitmentTypeIdentifier.proofOfOrigin, null);
        DERSequence qualifier = new DERSequence(new ASN1ObjectIdentifier("1.2"));
        cti = new CommitmentTypeIndication(CommitmentTypeIdentifier.proofOfOrigin, qualifier);
        this.checkConstruction(cti, CommitmentTypeIdentifier.proofOfOrigin, qualifier);
        cti = CommitmentTypeIndication.getInstance(null);
        if (cti != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            CommitmentTypeIndication.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(CommitmentTypeIndication mv, ASN1ObjectIdentifier commitmenttTypeId, ASN1Encodable qualifier) throws IOException {
        this.checkStatement(mv, commitmenttTypeId, qualifier);
        mv = CommitmentTypeIndication.getInstance(mv);
        this.checkStatement(mv, commitmenttTypeId, qualifier);
        ASN1InputStream aIn = new ASN1InputStream(mv.toASN1Primitive().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        mv = CommitmentTypeIndication.getInstance(seq);
        this.checkStatement(mv, commitmenttTypeId, qualifier);
    }

    private void checkStatement(CommitmentTypeIndication cti, ASN1ObjectIdentifier commitmentTypeId, ASN1Encodable qualifier) {
        if (!cti.getCommitmentTypeId().equals(commitmentTypeId)) {
            this.fail("commitmentTypeIds don't match.");
        }
        if (qualifier != null) {
            if (!cti.getCommitmentTypeQualifier().equals(qualifier)) {
                this.fail("qualifiers don't match.");
            }
        } else if (cti.getCommitmentTypeQualifier() != null) {
            this.fail("qualifier found when none expected.");
        }
    }

    public static void main(String[] args) {
        CommitmentTypeIndicationUnitTest.runTest(new CommitmentTypeIndicationUnitTest());
    }
}

