/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.its.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.its.ITSCertificate;
import net.savignano.thirdparty.org.bouncycastle.its.jcajce.JcaITSPublicVerificationKey;
import net.savignano.thirdparty.org.bouncycastle.its.operator.ITSContentVerifierProvider;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.JcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.oer.OEREncoder;
import net.savignano.thirdparty.org.bouncycastle.oer.its.PublicVerificationKey;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ToBeSignedCertificate;
import net.savignano.thirdparty.org.bouncycastle.oer.its.VerificationKeyIndicator;
import net.savignano.thirdparty.org.bouncycastle.oer.its.template.IEEE1609dot2;
import net.savignano.thirdparty.org.bouncycastle.operator.ContentVerifier;
import net.savignano.thirdparty.org.bouncycastle.operator.DigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.operator.DigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;
import net.savignano.thirdparty.org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class JcaITSContentVerifierProvider
implements ITSContentVerifierProvider {
    private final ITSCertificate issuer;
    private final byte[] parentData;
    private final AlgorithmIdentifier digestAlgo;
    private final ECPublicKey pubParams;
    private final int sigChoice;
    private JcaJceHelper helper;

    private JcaITSContentVerifierProvider(ITSCertificate issuer, JcaJceHelper helper) {
        PublicVerificationKey pvi;
        this.issuer = issuer;
        this.helper = helper;
        try {
            this.parentData = issuer.getEncoded();
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to extract parent data: " + e.getMessage());
        }
        ToBeSignedCertificate toBeSignedCertificate = issuer.toASN1Structure().getCertificateBase().getToBeSignedCertificate();
        VerificationKeyIndicator vki = toBeSignedCertificate.getVerificationKeyIndicator();
        if (vki.getObject() instanceof PublicVerificationKey) {
            pvi = PublicVerificationKey.getInstance(vki.getObject());
            this.sigChoice = pvi.getChoice();
            switch (pvi.getChoice()) {
                case 0: {
                    this.digestAlgo = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
                    break;
                }
                case 1: {
                    this.digestAlgo = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
                    break;
                }
                case 3: {
                    this.digestAlgo = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown key type");
                }
            }
        } else {
            throw new IllegalArgumentException("not public verification key");
        }
        this.pubParams = (ECPublicKey)new JcaITSPublicVerificationKey(pvi, helper).getKey();
    }

    public boolean hasAssociatedCertificate() {
        return this.issuer != null;
    }

    public ITSCertificate getAssociatedCertificate() {
        return this.issuer;
    }

    public ContentVerifier get(int verifierAlgorithmIdentifier) throws OperatorCreationException {
        DigestCalculatorProvider digestCalculatorProvider;
        if (this.sigChoice != verifierAlgorithmIdentifier) {
            throw new OperatorCreationException("wrong verifier for algorithm: " + verifierAlgorithmIdentifier);
        }
        try {
            JcaDigestCalculatorProviderBuilder bld = new JcaDigestCalculatorProviderBuilder().setHelper(this.helper);
            digestCalculatorProvider = bld.build();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        final DigestCalculator calculator = digestCalculatorProvider.get(this.digestAlgo);
        try {
            Signature signature;
            byte[] parentTBSDigest;
            final OutputStream os = calculator.getOutputStream();
            os.write(this.parentData, 0, this.parentData.length);
            final byte[] parentDigest = calculator.getDigest();
            if (this.issuer.getIssuer().isSelf()) {
                byte[] enc = OEREncoder.toByteArray(this.issuer.toASN1Structure().getCertificateBase().getToBeSignedCertificate(), IEEE1609dot2.tbsCertificate);
                os.write(enc, 0, enc.length);
                parentTBSDigest = calculator.getDigest();
            } else {
                parentTBSDigest = null;
            }
            switch (this.sigChoice) {
                case 0: 
                case 1: {
                    signature = this.helper.createSignature("SHA256withECDSA");
                    break;
                }
                case 3: {
                    signature = this.helper.createSignature("SHA384withECDSA");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("choice " + this.sigChoice + " not supported");
                }
            }
            return new ContentVerifier(){

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return null;
                }

                public OutputStream getOutputStream() {
                    return os;
                }

                public boolean verify(byte[] expected) {
                    byte[] clientCertDigest = calculator.getDigest();
                    try {
                        signature.initVerify(JcaITSContentVerifierProvider.this.pubParams);
                        signature.update(clientCertDigest);
                        if (parentTBSDigest != null && Arrays.areEqual(clientCertDigest, parentTBSDigest)) {
                            byte[] empty = calculator.getDigest();
                            signature.update(empty);
                        } else {
                            signature.update(parentDigest);
                        }
                        return signature.verify(expected);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex.getMessage(), ex);
                    }
                }
            };
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public static class Builder {
        private JcaJceHelper helper = new DefaultJcaJceHelper();

        public Builder setProvider(Provider provider) {
            this.helper = new ProviderJcaJceHelper(provider);
            return this;
        }

        public Builder setProvider(String providerName) {
            this.helper = new NamedJcaJceHelper(providerName);
            return this;
        }

        public JcaITSContentVerifierProvider build(ITSCertificate issuer) {
            return new JcaITSContentVerifierProvider(issuer, this.helper);
        }
    }
}

