/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.mail.smime.examples;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.AttributeTable;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import net.savignano.thirdparty.org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import net.savignano.thirdparty.org.bouncycastle.asn1.smime.SMIMECapability;
import net.savignano.thirdparty.org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.X500Name;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.Extension;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaCertStore;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMESignedGenerator;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;
import net.savignano.thirdparty.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CreateLargeSignedMail {
    static int serialNo = 1;

    static X509Certificate makeCertificate(KeyPair subKP, String subDN, KeyPair issKP, String issDN) throws GeneralSecurityException, IOException, OperatorCreationException {
        PublicKey subPub = subKP.getPublic();
        PrivateKey issPriv = issKP.getPrivate();
        PublicKey issPub = issKP.getPublic();
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        JcaX509v3CertificateBuilder v3CertGen = new JcaX509v3CertificateBuilder(new X500Name(issDN), BigInteger.valueOf(serialNo++), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 8640000000L), new X500Name(subDN), subPub);
        v3CertGen.addExtension(Extension.subjectKeyIdentifier, false, extUtils.createSubjectKeyIdentifier(subPub));
        v3CertGen.addExtension(Extension.authorityKeyIdentifier, false, extUtils.createAuthorityKeyIdentifier(issPub));
        return new JcaX509CertificateConverter().setProvider("SAVIGNANO-BC").getCertificate(v3CertGen.build(new JcaContentSignerBuilder("MD5withRSA").setProvider("SAVIGNANO-BC").build(issPriv)));
    }

    public static void main(String[] args) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "SAVIGNANO-BC");
        kpg.initialize(1024, new SecureRandom());
        String signDN = "O=Bouncy Castle, C=AU";
        KeyPair signKP = kpg.generateKeyPair();
        X509Certificate signCert = CreateLargeSignedMail.makeCertificate(signKP, signDN, signKP, signDN);
        String origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
        KeyPair origKP = kpg.generateKeyPair();
        X509Certificate origCert = CreateLargeSignedMail.makeCertificate(origKP, origDN, signKP, signDN);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(origCert);
        certList.add(signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
        SMIMECapabilityVector caps = new SMIMECapabilityVector();
        caps.addCapability(SMIMECapability.dES_EDE3_CBC);
        caps.addCapability(SMIMECapability.rC2_CBC, 128);
        caps.addCapability(SMIMECapability.dES_CBC);
        signedAttrs.add(new SMIMECapabilitiesAttribute(caps));
        IssuerAndSerialNumber issAndSer = new IssuerAndSerialNumber(new X500Name(signDN), origCert.getSerialNumber());
        signedAttrs.add(new SMIMEEncryptionKeyPreferenceAttribute(issAndSer));
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("SAVIGNANO-BC").setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build("SHA1withRSA", origKP.getPrivate(), origCert));
        gen.addCertificates(certs);
        MimeBodyPart msg = new MimeBodyPart();
        msg.setDataHandler(new DataHandler((DataSource)new FileDataSource(new File(args[0]))));
        msg.setHeader("Content-Type", "application/octet-stream");
        msg.setHeader("Content-Transfer-Encoding", "base64");
        MimeMultipart mm = gen.generate(msg);
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        InternetAddress fromUser = new InternetAddress("\"Eric H. Echidna\"<eric@bouncycastle.org>");
        InternetAddress toUser = new InternetAddress("example@bouncycastle.org");
        MimeMessage body = new MimeMessage(session);
        body.setFrom((Address)fromUser);
        body.setRecipient(Message.RecipientType.TO, (Address)toUser);
        body.setSubject("example signed message");
        body.setContent((Object)mm, mm.getContentType());
        body.saveChanges();
        body.writeTo((OutputStream)new FileOutputStream("signed.message"));
    }
}

