/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERNull;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Hostname;
import net.savignano.thirdparty.org.bouncycastle.oer.its.LinkageData;

public class CertificateId
extends ASN1Object
implements ASN1Choice {
    public static final int linkageData = 0;
    public static final int name = 1;
    public static final int binaryId = 2;
    public static final int none = 3;
    public static final int extension = 4;
    private final int choice;
    private final ASN1Encodable value;

    public CertificateId(int choice, ASN1Encodable value) {
        this.choice = choice;
        this.value = value;
    }

    public static CertificateId getInstance(Object o) {
        if (o instanceof CertificateId) {
            return (CertificateId)o;
        }
        ASN1TaggedObject asn1TaggedObject = ASN1TaggedObject.getInstance(o);
        int item = asn1TaggedObject.getTagNo();
        switch (item) {
            case 0: {
                return new CertificateId(item, LinkageData.getInstance(asn1TaggedObject.getObject()));
            }
            case 1: {
                return new CertificateId(item, Hostname.getInstance(asn1TaggedObject.getObject()));
            }
            case 2: 
            case 4: {
                return new CertificateId(item, DEROctetString.getInstance(asn1TaggedObject.getObject()));
            }
            case 3: {
                return new CertificateId(item, asn1TaggedObject.getObject());
            }
        }
        throw new IllegalArgumentException("unknown choice in CertificateId");
    }

    public static Builder builder() {
        return new Builder();
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.value).toASN1Primitive();
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getValue() {
        return this.value;
    }

    public static class Builder {
        private int choice;
        private ASN1Encodable value;

        public Builder setChoice(int choice) {
            this.choice = choice;
            return this;
        }

        public Builder setValue(ASN1Encodable value) {
            this.value = value;
            return this;
        }

        public Builder linkageData(LinkageData data) {
            this.choice = 0;
            this.value = data;
            return this;
        }

        public Builder name(Hostname data) {
            this.choice = 1;
            this.value = data;
            return this;
        }

        public Builder binaryId(DEROctetString data) {
            this.choice = 1;
            this.value = data;
            return this;
        }

        public Builder none() {
            this.choice = 1;
            this.value = DERNull.INSTANCE;
            return this;
        }

        public Builder extension(byte[] data) {
            this.choice = 4;
            this.value = new DEROctetString(data);
            return this;
        }

        public CertificateId createCertificateId() {
            return new CertificateId(this.choice, this.value);
        }
    }
}

