/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;

public class Duration
extends ASN1Object
implements ASN1Choice {
    public static final int microseconds = 0;
    public static final int milliseconds = 1;
    public static final int seconds = 2;
    public static final int minutes = 3;
    public static final int hours = 4;
    public static final int sixtyHours = 5;
    public static final int years = 6;
    private final int tag;
    private final int value;

    public Duration(int tag, int value) {
        this.tag = tag;
        this.value = value;
    }

    public static Duration getInstance(Object o) {
        if (o instanceof Duration) {
            return (Duration)o;
        }
        ASN1TaggedObject taggedObject = ASN1TaggedObject.getInstance(o);
        int choice = taggedObject.getTagNo();
        switch (choice) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                try {
                    return new Duration(choice, ASN1Integer.getInstance(taggedObject.getObject()).getValue().intValue());
                }
                catch (Exception ioex) {
                    throw new IllegalStateException(ioex.getMessage(), ioex);
                }
            }
        }
        throw new IllegalArgumentException("invalid choice value " + choice);
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.tag, new ASN1Integer(this.value));
    }

    public int getTag() {
        return this.tag;
    }

    public int getValue() {
        return this.value;
    }
}

