/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;

public class OneEightyDegreeInt
extends ASN1Integer {
    private static final BigInteger loweBound = new BigInteger("-1799999999");
    private static final BigInteger upperBound = new BigInteger("1800000000");
    private static final BigInteger unknown = new BigInteger("1800000001");

    public OneEightyDegreeInt(long value) {
        super(value);
        this.assertValue();
    }

    public OneEightyDegreeInt(BigInteger value) {
        super(value);
        this.assertValue();
    }

    public OneEightyDegreeInt(byte[] bytes) {
        super(bytes);
        this.assertValue();
    }

    public static OneEightyDegreeInt getInstance(Object o) {
        if (o instanceof OneEightyDegreeInt) {
            return (OneEightyDegreeInt)o;
        }
        return new OneEightyDegreeInt(ASN1Integer.getInstance(o).getValue());
    }

    public void assertValue() {
        BigInteger bi = this.getValue();
        if (bi.compareTo(loweBound) < 0) {
            throw new IllegalStateException("one eighty degree int cannot be less than -1799999999");
        }
        if (bi.equals(unknown)) {
            return;
        }
        if (bi.compareTo(upperBound) > 0) {
            throw new IllegalStateException("one eighty degree int cannot be greater than 1800000000");
        }
    }
}

