/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.oer.OEROptional;
import net.savignano.thirdparty.org.bouncycastle.oer.its.SspRange;

public class PsidSspRange
extends ASN1Object {
    private final ASN1Integer psid;
    private final OEROptional sspRange;

    public PsidSspRange(ASN1Integer psid, OEROptional sspRange) {
        this.psid = psid;
        this.sspRange = sspRange;
    }

    public PsidSspRange(ASN1Integer psid, SspRange sspRange) {
        this.psid = psid;
        this.sspRange = OEROptional.getInstance(sspRange);
    }

    public static PsidSspRange getInstance(Object src) {
        if (src == null) {
            return null;
        }
        if (src instanceof PsidSspRange) {
            return (PsidSspRange)src;
        }
        ASN1Sequence seq = ASN1Sequence.getInstance(src);
        return new PsidSspRange(ASN1Integer.getInstance(seq.getObjectAt(0)), OEROptional.getInstance(seq.getObjectAt(1)));
    }

    public static Builder builder() {
        return new Builder();
    }

    public ASN1Integer getPsid() {
        return this.psid;
    }

    public OEROptional getSspRange() {
        return this.sspRange;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector avec = new ASN1EncodableVector();
        avec.add(this.psid);
        if (this.sspRange != null) {
            avec.add(this.sspRange);
        }
        return new DERSequence(avec);
    }

    public static class Builder {
        private ASN1Integer psid;
        private OEROptional sspRange = OEROptional.ABSENT;

        public Builder setPsid(ASN1Integer psid) {
            this.psid = psid;
            return this;
        }

        public Builder setPsid(long psid) {
            this.psid = new ASN1Integer(psid);
            return this;
        }

        public Builder setSspRange(SspRange sspRange) {
            this.sspRange = OEROptional.getInstance(sspRange);
            return this;
        }

        public PsidSspRange createPsidSspRange() {
            return new PsidSspRange(this.psid, this.sspRange);
        }
    }
}

