/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.InputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.InputStreamPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPKeyValidationException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSessionKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.io.TeeInputStream;

public class PGPPublicKeyEncryptedData
extends PGPEncryptedData {
    PublicKeyEncSessionPacket keyData;

    PGPPublicKeyEncryptedData(PublicKeyEncSessionPacket keyData, InputStreamPacket encData) {
        super(encData);
        this.keyData = keyData;
    }

    private boolean confirmCheckSum(byte[] sessionInfo) {
        int check = 0;
        for (int i = 1; i != sessionInfo.length - 2; ++i) {
            check += sessionInfo[i] & 0xFF;
        }
        return sessionInfo[sessionInfo.length - 2] == (byte)(check >> 8) && sessionInfo[sessionInfo.length - 1] == (byte)check;
    }

    public long getKeyID() {
        return this.keyData.getKeyID();
    }

    public int getSymmetricAlgorithm(PublicKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        byte[] plain = dataDecryptorFactory.recoverSessionData(this.keyData.getAlgorithm(), this.keyData.getEncSessionKey());
        return plain[0];
    }

    public PGPSessionKey getSessionKey(PublicKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        byte[] sessionData = dataDecryptorFactory.recoverSessionData(this.keyData.getAlgorithm(), this.keyData.getEncSessionKey());
        if (!this.confirmCheckSum(sessionData)) {
            throw new PGPKeyValidationException("key checksum failed");
        }
        return new PGPSessionKey(sessionData[0] & 0xFF, Arrays.copyOfRange(sessionData, 1, sessionData.length - 2));
    }

    public InputStream getDataStream(PublicKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        return this.getDataStream(dataDecryptorFactory, this.getSessionKey(dataDecryptorFactory));
    }

    public InputStream getDataStream(SessionKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        return this.getDataStream(dataDecryptorFactory, dataDecryptorFactory.getSessionKey());
    }

    private InputStream getDataStream(PGPDataDecryptorFactory dataDecryptorFactory, PGPSessionKey sessionKey) throws PGPException {
        if (sessionKey.getAlgorithm() != 0) {
            try {
                boolean withIntegrityPacket = this.encData instanceof SymmetricEncIntegrityPacket;
                PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(withIntegrityPacket, sessionKey.getAlgorithm(), sessionKey.getKey());
                BCPGInputStream encIn = this.encData.getInputStream();
                this.encStream = new BCPGInputStream(dataDecryptor.getInputStream(encIn));
                if (withIntegrityPacket) {
                    this.truncStream = new PGPEncryptedData.TruncatedStream(this.encStream);
                    this.integrityCalculator = dataDecryptor.getIntegrityCalculator();
                    this.encStream = new TeeInputStream(this.truncStream, this.integrityCalculator.getOutputStream());
                }
                byte[] iv = new byte[dataDecryptor.getBlockSize()];
                for (int i = 0; i != iv.length; ++i) {
                    int ch = this.encStream.read();
                    if (ch < 0) {
                        throw new EOFException("unexpected end of stream.");
                    }
                    iv[i] = (byte)ch;
                }
                int v1 = this.encStream.read();
                int v2 = this.encStream.read();
                if (v1 < 0 || v2 < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                return this.encStream;
            }
            catch (PGPException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PGPException("Exception starting decryption", e);
            }
        }
        return this.encData.getInputStream();
    }
}

