/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsContext;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsUtils;

public final class DigitallySigned {
    private final SignatureAndHashAlgorithm algorithm;
    private final byte[] signature;

    public DigitallySigned(SignatureAndHashAlgorithm algorithm, byte[] signature) {
        if (signature == null) {
            throw new IllegalArgumentException("'signature' cannot be null");
        }
        this.algorithm = algorithm;
        this.signature = signature;
    }

    public SignatureAndHashAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void encode(OutputStream output) throws IOException {
        if (this.algorithm != null) {
            this.algorithm.encode(output);
        }
        TlsUtils.writeOpaque16(this.signature, output);
    }

    public static DigitallySigned parse(TlsContext context, InputStream input) throws IOException {
        SignatureAndHashAlgorithm algorithm = null;
        if (TlsUtils.isTLSv12(context) && 0 == (algorithm = SignatureAndHashAlgorithm.parse(input)).getSignature()) {
            throw new TlsFatalAlert(47);
        }
        byte[] signature = TlsUtils.readOpaque16(input);
        return new DigitallySigned(algorithm, signature);
    }
}

