/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsUtils;

public final class ServerName {
    private final short nameType;
    private final byte[] nameData;

    public ServerName(short nameType, byte[] nameData) {
        if (!TlsUtils.isValidUint8(nameType)) {
            throw new IllegalArgumentException("'nameType' must be from 0 to 255");
        }
        if (null == nameData) {
            throw new NullPointerException("'nameData' cannot be null");
        }
        if (nameData.length < 1 || !TlsUtils.isValidUint16(nameData.length)) {
            throw new IllegalArgumentException("'nameData' must have length from 1 to 65535");
        }
        this.nameType = nameType;
        this.nameData = nameData;
    }

    public short getNameType() {
        return this.nameType;
    }

    public byte[] getNameData() {
        return this.nameData;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.nameType, output);
        TlsUtils.writeOpaque16(this.nameData, output);
    }

    public static ServerName parse(InputStream input) throws IOException {
        short name_type = TlsUtils.readUint8(input);
        byte[] nameData = TlsUtils.readOpaque16(input, 1);
        return new ServerName(name_type, nameData);
    }
}

