/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.BlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.agreement.srp.SRP6Client;
import net.savignano.thirdparty.org.bouncycastle.crypto.agreement.srp.SRP6Server;
import net.savignano.thirdparty.org.bouncycastle.crypto.agreement.srp.SRP6VerifierGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.MD5Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHA1Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHA224Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHA256Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHA384Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHA512Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SM3Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.engines.AESEngine;
import net.savignano.thirdparty.org.bouncycastle.crypto.engines.ARIAEngine;
import net.savignano.thirdparty.org.bouncycastle.crypto.engines.CamelliaEngine;
import net.savignano.thirdparty.org.bouncycastle.crypto.engines.DESedeEngine;
import net.savignano.thirdparty.org.bouncycastle.crypto.engines.SEEDEngine;
import net.savignano.thirdparty.org.bouncycastle.crypto.engines.SM4Engine;
import net.savignano.thirdparty.org.bouncycastle.crypto.macs.HMac;
import net.savignano.thirdparty.org.bouncycastle.crypto.modes.AEADBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.modes.CBCBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.modes.CCMBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.modes.GCMBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.SRP6GroupParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.prng.DigestRandomGenerator;
import net.savignano.thirdparty.org.bouncycastle.tls.NamedGroup;
import net.savignano.thirdparty.org.bouncycastle.tls.ProtocolVersion;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureScheme;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsUtils;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsCertificate;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsCipher;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsCryptoParameters;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsCryptoUtils;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsDHConfig;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsDHDomain;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsECConfig;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsECDomain;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsHMAC;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsHash;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsNonceGenerator;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsSRP6Client;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsSRP6Server;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsSRPConfig;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsSecret;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.TlsAEADCipher;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.TlsBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.TlsNullCipher;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcChaCha20Poly1305;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcSSL3HMAC;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsAEADCipherImpl;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsBlockCipherImpl;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsDHDomain;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsECDomain;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsHMAC;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsHash;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsNonceGenerator;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsSRP6Client;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsSRP6Server;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsSRP6VerifierGenerator;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcX25519Domain;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcX448Domain;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class BcTlsCrypto
extends AbstractTlsCrypto {
    private final SecureRandom entropySource;

    public BcTlsCrypto(SecureRandom entropySource) {
        this.entropySource = entropySource;
    }

    BcTlsSecret adoptLocalSecret(byte[] data) {
        return new BcTlsSecret(this, data);
    }

    public SecureRandom getSecureRandom() {
        return this.entropySource;
    }

    public TlsCertificate createCertificate(byte[] encoding) throws IOException {
        return new BcTlsCertificate(this, encoding);
    }

    public TlsCipher createCipher(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        switch (encryptionAlgorithm) {
            case 8: 
            case 12: 
            case 14: 
            case 22: 
            case 28: {
                return this.createCipher_CBC(cryptoParams, encryptionAlgorithm, 16, macAlgorithm);
            }
            case 7: {
                return this.createCipher_CBC(cryptoParams, encryptionAlgorithm, 24, macAlgorithm);
            }
            case 9: 
            case 13: 
            case 23: {
                return this.createCipher_CBC(cryptoParams, encryptionAlgorithm, 32, macAlgorithm);
            }
            case 15: {
                return this.createCipher_AES_CCM(cryptoParams, 16, 16);
            }
            case 16: {
                return this.createCipher_AES_CCM(cryptoParams, 16, 8);
            }
            case 10: {
                return this.createCipher_AES_GCM(cryptoParams, 16, 16);
            }
            case 17: {
                return this.createCipher_AES_CCM(cryptoParams, 32, 16);
            }
            case 18: {
                return this.createCipher_AES_CCM(cryptoParams, 32, 8);
            }
            case 11: {
                return this.createCipher_AES_GCM(cryptoParams, 32, 16);
            }
            case 24: {
                return this.createCipher_ARIA_GCM(cryptoParams, 16, 16);
            }
            case 25: {
                return this.createCipher_ARIA_GCM(cryptoParams, 32, 16);
            }
            case 19: {
                return this.createCipher_Camellia_GCM(cryptoParams, 16, 16);
            }
            case 20: {
                return this.createCipher_Camellia_GCM(cryptoParams, 32, 16);
            }
            case 21: {
                return this.createChaCha20Poly1305(cryptoParams);
            }
            case 0: {
                return this.createNullCipher(cryptoParams, macAlgorithm);
            }
            case 26: {
                return this.createCipher_SM4_CCM(cryptoParams);
            }
            case 27: {
                return this.createCipher_SM4_GCM(cryptoParams);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsDHDomain createDHDomain(TlsDHConfig dhConfig) {
        return new BcTlsDHDomain(this, dhConfig);
    }

    public TlsECDomain createECDomain(TlsECConfig ecConfig) {
        switch (ecConfig.getNamedGroup()) {
            case 29: {
                return new BcX25519Domain(this);
            }
            case 30: {
                return new BcX448Domain(this);
            }
        }
        return new BcTlsECDomain(this, ecConfig);
    }

    public TlsNonceGenerator createNonceGenerator(byte[] additionalSeedMaterial) {
        Digest digest = this.createDigest(4);
        byte[] seed = new byte[digest.getDigestSize()];
        this.getSecureRandom().nextBytes(seed);
        DigestRandomGenerator nonceGen = new DigestRandomGenerator(digest);
        nonceGen.addSeedMaterial(additionalSeedMaterial);
        nonceGen.addSeedMaterial(seed);
        return new BcTlsNonceGenerator(nonceGen);
    }

    public boolean hasAllRawSignatureAlgorithms() {
        return !this.hasSignatureAlgorithm((short)7) && !this.hasSignatureAlgorithm((short)8);
    }

    public boolean hasDHAgreement() {
        return true;
    }

    public boolean hasECDHAgreement() {
        return true;
    }

    public boolean hasEncryptionAlgorithm(int encryptionAlgorithm) {
        switch (encryptionAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return false;
            }
        }
        return true;
    }

    public boolean hasCryptoHashAlgorithm(int cryptoHashAlgorithm) {
        return true;
    }

    public boolean hasCryptoSignatureAlgorithm(int cryptoSignatureAlgorithm) {
        switch (cryptoSignatureAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean hasMacAlgorithm(int macAlgorithm) {
        return true;
    }

    public boolean hasNamedGroup(int namedGroup) {
        return NamedGroup.refersToASpecificGroup(namedGroup);
    }

    public boolean hasRSAEncryption() {
        return true;
    }

    public boolean hasSignatureAlgorithm(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm sigAndHashAlgorithm) {
        short signature = sigAndHashAlgorithm.getSignature();
        switch (sigAndHashAlgorithm.getHash()) {
            case 1: {
                return 1 == signature && this.hasSignatureAlgorithm(signature);
            }
        }
        return this.hasSignatureAlgorithm(signature);
    }

    public boolean hasSignatureScheme(int signatureScheme) {
        switch (signatureScheme) {
            case 1800: {
                return false;
            }
        }
        short signature = SignatureScheme.getSignatureAlgorithm(signatureScheme);
        switch (SignatureScheme.getCryptoHashAlgorithm(signatureScheme)) {
            case 1: {
                return 1 == signature && this.hasSignatureAlgorithm(signature);
            }
        }
        return this.hasSignatureAlgorithm(signature);
    }

    public boolean hasSRPAuthentication() {
        return true;
    }

    public TlsSecret createSecret(byte[] data) {
        return this.adoptLocalSecret(Arrays.clone(data));
    }

    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion version) {
        byte[] data = new byte[48];
        this.getSecureRandom().nextBytes(data);
        TlsUtils.writeVersion(version, data, 0);
        return this.adoptLocalSecret(data);
    }

    public Digest cloneDigest(int cryptoHashAlgorithm, Digest digest) {
        switch (cryptoHashAlgorithm) {
            case 1: {
                return new MD5Digest((MD5Digest)digest);
            }
            case 2: {
                return new SHA1Digest((SHA1Digest)digest);
            }
            case 3: {
                return new SHA224Digest((SHA224Digest)digest);
            }
            case 4: {
                return new SHA256Digest((SHA256Digest)digest);
            }
            case 5: {
                return new SHA384Digest((SHA384Digest)digest);
            }
            case 6: {
                return new SHA512Digest((SHA512Digest)digest);
            }
            case 7: {
                return new SM3Digest((SM3Digest)digest);
            }
        }
        throw new IllegalArgumentException("invalid CryptoHashAlgorithm: " + cryptoHashAlgorithm);
    }

    public Digest createDigest(int cryptoHashAlgorithm) {
        switch (cryptoHashAlgorithm) {
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA224Digest();
            }
            case 4: {
                return new SHA256Digest();
            }
            case 5: {
                return new SHA384Digest();
            }
            case 6: {
                return new SHA512Digest();
            }
            case 7: {
                return new SM3Digest();
            }
        }
        throw new IllegalArgumentException("invalid CryptoHashAlgorithm: " + cryptoHashAlgorithm);
    }

    public TlsHash createHash(int cryptoHashAlgorithm) {
        return new BcTlsHash(this, cryptoHashAlgorithm);
    }

    protected BlockCipher createBlockCipher(int encryptionAlgorithm) throws IOException {
        switch (encryptionAlgorithm) {
            case 7: {
                return this.createDESedeEngine();
            }
            case 8: 
            case 9: {
                return this.createAESEngine();
            }
            case 22: 
            case 23: {
                return this.createARIAEngine();
            }
            case 12: 
            case 13: {
                return this.createCamelliaEngine();
            }
            case 14: {
                return this.createSEEDEngine();
            }
            case 28: {
                return this.createSM4Engine();
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected BlockCipher createCBCBlockCipher(BlockCipher blockCipher) {
        return new CBCBlockCipher(blockCipher);
    }

    protected BlockCipher createCBCBlockCipher(int encryptionAlgorithm) throws IOException {
        return this.createCBCBlockCipher(this.createBlockCipher(encryptionAlgorithm));
    }

    protected TlsCipher createChaCha20Poly1305(TlsCryptoParameters cryptoParams) throws IOException {
        return new TlsAEADCipher(cryptoParams, new BcChaCha20Poly1305(true), new BcChaCha20Poly1305(false), 32, 16, 2);
    }

    protected TlsAEADCipher createCipher_AES_CCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        BcTlsAEADCipherImpl encrypt = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_AES_CCM(), true);
        BcTlsAEADCipherImpl decrypt = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_AES_CCM(), false);
        return new TlsAEADCipher(cryptoParams, encrypt, decrypt, cipherKeySize, macSize, 1);
    }

    protected TlsAEADCipher createCipher_AES_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        BcTlsAEADCipherImpl encrypt = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_AES_GCM(), true);
        BcTlsAEADCipherImpl decrypt = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_AES_GCM(), false);
        return new TlsAEADCipher(cryptoParams, encrypt, decrypt, cipherKeySize, macSize, 3);
    }

    protected TlsAEADCipher createCipher_ARIA_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        BcTlsAEADCipherImpl encrypt = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_ARIA_GCM(), true);
        BcTlsAEADCipherImpl decrypt = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_ARIA_GCM(), false);
        return new TlsAEADCipher(cryptoParams, encrypt, decrypt, cipherKeySize, macSize, 3);
    }

    protected TlsAEADCipher createCipher_Camellia_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        BcTlsAEADCipherImpl encrypt = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_Camellia_GCM(), true);
        BcTlsAEADCipherImpl decrypt = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_Camellia_GCM(), false);
        return new TlsAEADCipher(cryptoParams, encrypt, decrypt, cipherKeySize, macSize, 3);
    }

    protected TlsCipher createCipher_CBC(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int cipherKeySize, int macAlgorithm) throws IOException {
        BcTlsBlockCipherImpl encrypt = new BcTlsBlockCipherImpl(this.createCBCBlockCipher(encryptionAlgorithm), true);
        BcTlsBlockCipherImpl decrypt = new BcTlsBlockCipherImpl(this.createCBCBlockCipher(encryptionAlgorithm), false);
        TlsHMAC clientMAC = this.createMAC(cryptoParams, macAlgorithm);
        TlsHMAC serverMAC = this.createMAC(cryptoParams, macAlgorithm);
        return new TlsBlockCipher(cryptoParams, encrypt, decrypt, clientMAC, serverMAC, cipherKeySize);
    }

    protected TlsAEADCipher createCipher_SM4_CCM(TlsCryptoParameters cryptoParams) throws IOException {
        BcTlsAEADCipherImpl encrypt = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_SM4_CCM(), true);
        BcTlsAEADCipherImpl decrypt = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_SM4_CCM(), false);
        return new TlsAEADCipher(cryptoParams, encrypt, decrypt, 16, 16, 1);
    }

    protected TlsAEADCipher createCipher_SM4_GCM(TlsCryptoParameters cryptoParams) throws IOException {
        BcTlsAEADCipherImpl encrypt = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_SM4_GCM(), true);
        BcTlsAEADCipherImpl decrypt = new BcTlsAEADCipherImpl(this.createAEADBlockCipher_SM4_GCM(), false);
        return new TlsAEADCipher(cryptoParams, encrypt, decrypt, 16, 16, 3);
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        return new TlsNullCipher(cryptoParams, this.createMAC(cryptoParams, macAlgorithm), this.createMAC(cryptoParams, macAlgorithm));
    }

    protected BlockCipher createAESEngine() {
        return new AESEngine();
    }

    protected BlockCipher createARIAEngine() {
        return new ARIAEngine();
    }

    protected BlockCipher createCamelliaEngine() {
        return new CamelliaEngine();
    }

    protected BlockCipher createDESedeEngine() {
        return new DESedeEngine();
    }

    protected BlockCipher createSEEDEngine() {
        return new SEEDEngine();
    }

    protected BlockCipher createSM4Engine() {
        return new SM4Engine();
    }

    protected AEADBlockCipher createCCMMode(BlockCipher engine) {
        return new CCMBlockCipher(engine);
    }

    protected AEADBlockCipher createGCMMode(BlockCipher engine) {
        return new GCMBlockCipher(engine);
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_CCM() {
        return this.createCCMMode(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_GCM() {
        return this.createGCMMode(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_ARIA_GCM() {
        return this.createGCMMode(this.createARIAEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_Camellia_GCM() {
        return this.createGCMMode(this.createCamelliaEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_SM4_CCM() {
        return this.createCCMMode(this.createSM4Engine());
    }

    protected AEADBlockCipher createAEADBlockCipher_SM4_GCM() {
        return this.createGCMMode(this.createSM4Engine());
    }

    public TlsHMAC createHMAC(int macAlgorithm) {
        return this.createHMACForHash(TlsCryptoUtils.getHashForHMAC(macAlgorithm));
    }

    public TlsHMAC createHMACForHash(int cryptoHashAlgorithm) {
        return new BcTlsHMAC(new HMac(this.createDigest(cryptoHashAlgorithm)));
    }

    protected TlsHMAC createHMAC_SSL(int macAlgorithm) throws IOException {
        switch (macAlgorithm) {
            case 1: {
                return new BcSSL3HMAC(this.createDigest(1));
            }
            case 2: {
                return new BcSSL3HMAC(this.createDigest(2));
            }
            case 3: {
                return new BcSSL3HMAC(this.createDigest(4));
            }
            case 4: {
                return new BcSSL3HMAC(this.createDigest(5));
            }
            case 5: {
                return new BcSSL3HMAC(this.createDigest(6));
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsHMAC createMAC(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        if (TlsImplUtils.isSSL(cryptoParams)) {
            return this.createHMAC_SSL(macAlgorithm);
        }
        return this.createHMAC(macAlgorithm);
    }

    public TlsSRP6Client createSRP6Client(TlsSRPConfig srpConfig) {
        BigInteger[] ng = srpConfig.getExplicitNG();
        SRP6GroupParameters srpGroup = new SRP6GroupParameters(ng[0], ng[1]);
        SRP6Client srp6Client = new SRP6Client();
        srp6Client.init(srpGroup, this.createDigest(2), this.getSecureRandom());
        return new BcTlsSRP6Client(srp6Client);
    }

    public TlsSRP6Server createSRP6Server(TlsSRPConfig srpConfig, BigInteger srpVerifier) {
        BigInteger[] ng = srpConfig.getExplicitNG();
        SRP6GroupParameters srpGroup = new SRP6GroupParameters(ng[0], ng[1]);
        SRP6Server srp6Server = new SRP6Server();
        srp6Server.init(srpGroup, srpVerifier, this.createDigest(2), this.getSecureRandom());
        return new BcTlsSRP6Server(srp6Server);
    }

    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig srpConfig) {
        BigInteger[] ng = srpConfig.getExplicitNG();
        SRP6VerifierGenerator srp6VerifierGenerator = new SRP6VerifierGenerator();
        srp6VerifierGenerator.init(ng[0], ng[1], this.createDigest(2));
        return new BcTlsSRP6VerifierGenerator(srp6VerifierGenerator);
    }

    public TlsSecret hkdfInit(int cryptoHashAlgorithm) {
        return this.adoptLocalSecret(new byte[TlsCryptoUtils.getHashOutputSize(cryptoHashAlgorithm)]);
    }
}

