/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.Provider;
import java.security.Security;
import net.savignano.thirdparty.org.bouncycastle.tls.HashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

class JcaUtils {
    JcaUtils() {
    }

    static String getJcaAlgorithmName(SignatureAndHashAlgorithm algorithm) {
        return HashAlgorithm.getName(algorithm.getHash()) + "WITH" + Strings.toUpperCase(SignatureAlgorithm.getName(algorithm.getSignature()));
    }

    static boolean isSunMSCAPIProviderActive() {
        return null != Security.getProvider("SunMSCAPI");
    }

    static boolean isSunMSCAPIProvider(Provider provider) {
        return null != provider && JcaUtils.isSunMSCAPIProviderName(provider.getName());
    }

    static boolean isSunMSCAPIProviderName(String providerName) {
        return "SunMSCAPI".equals(providerName);
    }
}

