/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tsp.ers;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.asn1.tsp.ArchiveTimeStamp;
import net.savignano.thirdparty.org.bouncycastle.asn1.tsp.PartialHashtree;
import net.savignano.thirdparty.org.bouncycastle.asn1.tsp.TSTInfo;
import net.savignano.thirdparty.org.bouncycastle.operator.DigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.tsp.TSPException;
import net.savignano.thirdparty.org.bouncycastle.tsp.TimeStampRequest;
import net.savignano.thirdparty.org.bouncycastle.tsp.TimeStampRequestGenerator;
import net.savignano.thirdparty.org.bouncycastle.tsp.TimeStampResponse;
import net.savignano.thirdparty.org.bouncycastle.tsp.ers.BinaryTreeRootCalculator;
import net.savignano.thirdparty.org.bouncycastle.tsp.ers.ERSArchiveTimeStamp;
import net.savignano.thirdparty.org.bouncycastle.tsp.ers.ERSData;
import net.savignano.thirdparty.org.bouncycastle.tsp.ers.ERSDataGroup;
import net.savignano.thirdparty.org.bouncycastle.tsp.ers.ERSException;
import net.savignano.thirdparty.org.bouncycastle.tsp.ers.ERSRootNodeCalculator;
import net.savignano.thirdparty.org.bouncycastle.tsp.ers.ERSUtil;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERSArchiveTimeStampGenerator {
    private final DigestCalculator digCalc;
    private List<ERSData> dataObjects = new ArrayList<ERSData>();
    private ERSRootNodeCalculator rootNodeCalculator = new BinaryTreeRootCalculator();

    public ERSArchiveTimeStampGenerator(DigestCalculator digCalc) {
        this.digCalc = digCalc;
    }

    public void addData(ERSData dataObject) {
        this.dataObjects.add(dataObject);
    }

    public void addAllData(List<ERSData> dataObjects) {
        this.dataObjects.addAll(dataObjects);
    }

    public TimeStampRequest generateTimeStampRequest(TimeStampRequestGenerator tspReqGenerator) throws TSPException, IOException {
        PartialHashtree[] reducedHashTree = this.getPartialHashtrees();
        byte[] rootHash = this.rootNodeCalculator.computeRootHash(this.digCalc, reducedHashTree);
        return tspReqGenerator.generate(this.digCalc.getAlgorithmIdentifier(), rootHash);
    }

    public TimeStampRequest generateTimeStampRequest(TimeStampRequestGenerator tspReqGenerator, BigInteger nonce) throws TSPException, IOException {
        PartialHashtree[] reducedHashTree = this.getPartialHashtrees();
        byte[] rootHash = this.rootNodeCalculator.computeRootHash(this.digCalc, reducedHashTree);
        return tspReqGenerator.generate(this.digCalc.getAlgorithmIdentifier(), rootHash, nonce);
    }

    public ERSArchiveTimeStamp generateArchiveTimeStamp(TimeStampResponse tspResponse) throws TSPException, ERSException {
        PartialHashtree[] reducedHashTree = this.getPartialHashtrees();
        byte[] rootHash = this.rootNodeCalculator.computeRootHash(this.digCalc, reducedHashTree);
        TSTInfo tstInfo = tspResponse.getTimeStampToken().getTimeStampInfo().toASN1Structure();
        if (!tstInfo.getMessageImprint().getHashAlgorithm().equals(this.digCalc.getAlgorithmIdentifier())) {
            throw new ERSException("time stamp imprint for wrong algorithm");
        }
        if (!Arrays.areEqual(tstInfo.getMessageImprint().getHashedMessage(), rootHash)) {
            throw new ERSException("time stamp imprint for wrong root hash");
        }
        ArchiveTimeStamp ats = reducedHashTree.length == 1 ? new ArchiveTimeStamp(null, null, tspResponse.getTimeStampToken().toCMSSignedData().toASN1Structure()) : new ArchiveTimeStamp(this.digCalc.getAlgorithmIdentifier(), reducedHashTree, tspResponse.getTimeStampToken().toCMSSignedData().toASN1Structure());
        return new ERSArchiveTimeStamp(ats, this.digCalc, this.rootNodeCalculator);
    }

    private PartialHashtree[] getPartialHashtrees() {
        int i;
        List<byte[]> hashes = ERSUtil.buildHashList(this.digCalc, this.dataObjects);
        PartialHashtree[] trees = new PartialHashtree[hashes.size()];
        HashSet<ERSDataGroup> dataGroupSet = new HashSet<ERSDataGroup>();
        for (i = 0; i != this.dataObjects.size(); ++i) {
            if (!(this.dataObjects.get(i) instanceof ERSDataGroup)) continue;
            dataGroupSet.add((ERSDataGroup)this.dataObjects.get(i));
        }
        for (i = 0; i != hashes.size(); ++i) {
            byte[] hash = hashes.get(i);
            ERSDataGroup found = null;
            for (ERSDataGroup data : dataGroupSet) {
                byte[] dHash = data.getHash(this.digCalc);
                if (!Arrays.areEqual(dHash, hash)) continue;
                List<byte[]> dHashes = data.getHashes(this.digCalc);
                trees[i] = new PartialHashtree((byte[][])dHashes.toArray((T[])new byte[dHashes.size()][]));
                found = data;
                break;
            }
            if (found == null) {
                trees[i] = new PartialHashtree(hash);
                continue;
            }
            dataGroupSet.remove(found);
        }
        return trees;
    }
}

