/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader;

import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.info.InfoDataManager;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.IKeyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AKeyLoader<T extends ICryptographyKey<?>, U>
implements IKeyLoader<T, U> {
    public static final int INFO_LOADED_KEY = 100;
    public static final int INFO_NULL_KEY = 101;
    public static final int INFO_ERROR = 102;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InfoDataManager manager = new InfoDataManager();

    @Override
    public T loadKey(U forId) {
        T key = null;
        try {
            key = this.loadInternalKey(forId);
        }
        catch (Exception e) {
            this.getLog().error("Could not load key. Error message: " + e.getMessage(), (Throwable)e);
            this.getInfoDataManager().send(new InfoData(102, e));
        }
        if (key == null) {
            key = this.getValidityKey(EKeyValidity.ERROR);
            this.getInfoDataManager().send(new InfoData(101, new Object[0]));
        }
        this.getLog().debug("Loaded key: {}", key);
        this.getInfoDataManager().send(new InfoData(100, key));
        return key;
    }

    protected abstract T loadInternalKey(U var1) throws Exception;

    protected abstract T getValidityKey(EKeyValidity var1);

    public InfoDataManager getInfoDataManager() {
        return this.manager;
    }

    protected Logger getLog() {
        return this.log;
    }
}

