/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.AKeyLoader;
import net.savignano.cryptography.key.loader.IKeyLoader;

public class CompoundKeyLoader<T extends ICryptographyKey<?>, U>
extends AKeyLoader<T, U> {
    public static final int INFO_QUERY_KEY_LOADER = 200;
    private final List<IKeyLoader<T, U>> loaders;
    private final BiFunction<EKeyValidity, EKeySource, T> validityKeyFunction;
    private final ECryptographyType cryptography;

    public CompoundKeyLoader(BiFunction<EKeyValidity, EKeySource, T> createValidityKey) {
        this(null, createValidityKey);
    }

    public CompoundKeyLoader(Collection<IKeyLoader<T, U>> loaders, BiFunction<EKeyValidity, EKeySource, T> createValidityKey) {
        if (createValidityKey == null) {
            throw new IllegalArgumentException("Function must not be null.");
        }
        this.loaders = loaders == null ? new ArrayList<IKeyLoader<T, U>>(0) : new ArrayList<IKeyLoader<T, U>>(loaders);
        this.validityKeyFunction = createValidityKey;
        this.cryptography = ((ICryptographyKey)this.validityKeyFunction.apply(EKeyValidity.NOT_FOUND, EKeySource.UNKNOWN)).getCryptography();
    }

    @Override
    protected T loadInternalKey(U forId) throws Exception {
        ICryptographyKey bestKey = null;
        int i = 0;
        for (IKeyLoader<T, U> loader : this.loaders) {
            this.getInfoDataManager().send(new InfoData(200, new Object[]{i++, loader.getKeySource()}));
            T key = this.loadKey(loader, forId);
            if (!(bestKey = this.chooseBetterKey(bestKey, key)).isValid()) continue;
            break;
        }
        if (bestKey == null) {
            bestKey = (ICryptographyKey)this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        return (T)bestKey;
    }

    private T loadKey(IKeyLoader<T, U> loader, U forId) {
        try {
            this.getLog().debug("Loading key from location: {}", (Object)loader.getKeySource());
            return loader.loadKey(forId);
        }
        catch (Exception e) {
            this.getLog().error("Unexpected error retrieving key from: " + loader + ". Error message: " + e.getMessage(), (Throwable)e);
            return (T)((ICryptographyKey)this.validityKeyFunction.apply(EKeyValidity.ERROR, loader.getKeySource()));
        }
    }

    private T chooseBetterKey(T bestKey, T key) {
        if (bestKey == null) {
            return key;
        }
        if (key == null) {
            return bestKey;
        }
        if (key.getKeyValidity().compareTo(bestKey.getKeyValidity()) < 0) {
            return key;
        }
        return bestKey;
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.UNKNOWN;
    }

    @Override
    public ECryptographyType getCryptography() {
        return this.cryptography;
    }

    @Override
    protected T getValidityKey(EKeyValidity validity) {
        return (T)((ICryptographyKey)this.validityKeyFunction.apply(validity, EKeySource.UNKNOWN));
    }

    public List<IKeyLoader<T, U>> getKeyLoaders() {
        return this.loaders;
    }
}

