/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.pgp;

import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.AKeyBoxLoader;
import net.savignano.cryptography.key.pgp.PgpPublicKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.BlobType;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.KeyBox;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.PublicKeyRingBlob;

public class PgpKeyBoxLoader
extends AKeyBoxLoader<PgpPublicKey, PublicKeyRingBlob> {
    public PgpKeyBoxLoader(KeyBox keyBox) {
        super(keyBox, BlobType.OPEN_PGP_BLOB);
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected PgpPublicKey loadKeyFromBlob(PublicKeyRingBlob blob) throws Exception {
        PgpPublicKey key = new PgpPublicKey(blob.getPGPPublicKeyRing());
        key.setKeySource(this.getKeySource());
        return key;
    }

    @Override
    protected boolean isKeyForEmail(PgpPublicKey key, String email) {
        return PgpUtil.isKeyForEmail(key.getMasterKey(), email);
    }

    @Override
    protected PgpPublicKey getValidityKey(EKeyValidity validity) {
        return new PgpPublicKey(validity, this.getKeySource());
    }

    @Override
    public int compare(PgpPublicKey o1, PgpPublicKey o2) {
        int compared = super.compare(o1, o2);
        if (compared != 0) {
            return compared;
        }
        return PgpUtil.getKeyRingComparator().compare(o1.getKeyRing(), o2.getKeyRing());
    }
}

