/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.smime;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.loader.AKeyLoader;
import net.savignano.cryptography.key.smime.SmimeSignKey;
import net.savignano.cryptography.util.SmimeUtil;
import org.slf4j.Logger;

public class SmimeSignKeyStoreLoader
extends AKeyLoader<SmimeSignKey, String> {
    public static final int INFO_NO_KEY_STORE = 200;
    public static final int INFO_NO_EMAIL = 201;
    public static final int INFO_EMAIL_FOUND = 202;
    public static final int INFO_EMAIL_NOT_FOUND = 203;
    private final KeyStore keyStore;
    private final char[] password;

    public SmimeSignKeyStoreLoader(KeyStore keyStore, char[] password) {
        this.keyStore = keyStore;
        this.password = password;
    }

    @Override
    protected SmimeSignKey loadInternalKey(String email) throws Exception {
        if (this.keyStore == null) {
            this.getInfoDataManager().send(new InfoData(200, new Object[0]));
            throw new IllegalArgumentException("Key Store must not be null.");
        }
        if (email == null) {
            this.getInfoDataManager().send(new InfoData(201, new Object[0]));
            throw new IllegalArgumentException("Email must not be null.");
        }
        SmimeSignKey key = this.getValidKey(email);
        this.buildCertChain(key);
        return key;
    }

    private SmimeSignKey getValidKey(String email) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Logger log = this.getLog();
        log.debug("Looking up private key for email: <{}>", (Object)email);
        X509Certificate cert = SmimeUtil.getValidCertForEmail(this.getKeyStore(), email, EKeyPurpose.SIGNING);
        if (cert == null) {
            log.info("Found no valid certificate for email <{}> in private key store.", (Object)email);
            this.getInfoDataManager().send(new InfoData(203, email));
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        PrivateKey privateKey = SmimeUtil.getPrivateKeyForCert(this.getKeyStore(), cert, this.password);
        if (privateKey == null) {
            String alias = this.getKeyStore().getCertificateAlias(cert);
            log.warn("Found a valid certificate for email <{}> in private key store, but not the corresponding private key. Please make sure that the private key for the certificate with serial number {} is stored in the key store at alias \"{}\".", new Object[]{email, SmimeUtil.getSerialNumber(cert), alias});
            this.getInfoDataManager().send(new InfoData(203, email));
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.info("Found valid signing key for <{}>.", (Object)email);
        log.trace("Used private key: {}", (Object)privateKey);
        log.trace("Used certificate: {}", (Object)cert);
        this.getInfoDataManager().send(new InfoData(202, email));
        SmimeSignKey signKey = new SmimeSignKey(privateKey, cert, email);
        signKey.setKeySource(EKeySource.KEYSTORE);
        return signKey;
    }

    private void buildCertChain(SmimeSignKey key) throws KeyStoreException {
        if (!key.isValid()) {
            return;
        }
        Logger log = this.getLog();
        log.debug("Looking up intermediate certificates.");
        X509Certificate publicCert = key.getPublicCert();
        String alias = this.getKeyStore().getCertificateAlias(publicCert);
        Certificate[] chain = this.getKeyStore().getCertificateChain(alias);
        if (chain != null && chain.length > 1) {
            log.debug("Found {} intermediate certificate(s).", (Object)(chain.length - 2));
            for (int i = 1; i < chain.length - 1; ++i) {
                key.getIntermediateCerts().add((X509Certificate)chain[i]);
            }
            X509Certificate lastCert = (X509Certificate)chain[chain.length - 1];
            if (!lastCert.getSubjectX500Principal().equals(lastCert.getIssuerX500Principal())) {
                key.getIntermediateCerts().add(lastCert);
            }
            log.trace("Found intermediate certificates: {}", key.getIntermediateCerts());
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Listing all certificates in key store.");
            Enumeration<String> ksAliases = this.getKeyStore().aliases();
            while (ksAliases.hasMoreElements()) {
                String ksAlias = ksAliases.nextElement();
                X509Certificate certCandidate = (X509Certificate)this.getKeyStore().getCertificate(ksAlias);
                log.trace("Alias: {}; Subject: {}; Issuer: {}", new Object[]{ksAlias, certCandidate.getSubjectX500Principal(), certCandidate.getIssuerX500Principal()});
            }
        }
        log.debug("Fallback lookup of intermediate certificates.");
        X509Certificate cert = publicCert;
        while (cert != null) {
            if ((cert = this.getIssuerCert(cert)) == null) continue;
            key.getIntermediateCerts().add(cert);
        }
        log.trace("Found intermediate certificates: {}", key.getIntermediateCerts());
    }

    private X509Certificate getIssuerCert(X509Certificate cert) throws KeyStoreException {
        X500Principal issuerDN = cert.getIssuerX500Principal();
        if (issuerDN.equals(cert.getSubjectX500Principal())) {
            return null;
        }
        X509Certificate issuer = (X509Certificate)this.getKeyStore().getCertificate(issuerDN.getName());
        if (issuer != null) {
            return issuer;
        }
        Enumeration<String> aliases = this.getKeyStore().aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate certCandidate = (X509Certificate)this.getKeyStore().getCertificate(alias);
            if (!certCandidate.getSubjectX500Principal().equals(issuerDN)) continue;
            return certCandidate;
        }
        return null;
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.SMIME;
    }

    @Override
    protected SmimeSignKey getValidityKey(EKeyValidity validity) {
        return new SmimeSignKey(validity, this.getKeySource());
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String toString() {
        return "SmimePrivateKeyStoreLoader [keyStore=" + this.keyStore + ", password=*****]";
    }
}

