/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.sign;

import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.key.ISecretCryptographyKey;
import net.savignano.cryptography.mail.BaseMailCryptography;
import net.savignano.cryptography.mail.sign.IMailSigner;
import net.savignano.cryptography.util.MessageUtil;
import org.slf4j.Logger;

public abstract class AMailSigner<T extends ISecretCryptographyKey<?>>
extends BaseMailCryptography<T>
implements IMailSigner<T> {
    private static final String MAIL_HEADER_SIGNED_PATTERN = "by {0} using {3} signature";
    private static final String MAIL_HEADER_SIGNED_DEBUG_PATTERN = "by {0} {1} at {2} using {3} signature with {4}";

    protected AMailSigner(Session session, ECryptographyType cryptography) {
        super(session, cryptography);
    }

    @Override
    public void signMessage(MimeMessage msg, T key) throws IOException, MessagingException {
        if (msg == null) {
            return;
        }
        if (key == null) {
            throw new MessagingException("Cannot sign message because no key was provided.");
        }
        if (!key.isValid()) {
            throw new MessagingException("Cannot sign message because of key having validity: " + (Object)((Object)key.getKeyValidity()));
        }
        Logger log = this.getLog();
        String msgId = MessageUtil.getMessageId(msg);
        log.info("Signing message for {} with msg ID: {}", (Object)this.getCryptography(), (Object)msgId);
        this.traceMessage(msg, "Original email:\n{}\n");
        try {
            this.sign(msg, key);
        }
        catch (IOException | MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            String errMsg = "Could not sign message with msg ID " + msgId + ". Error message: " + e.getMessage();
            log.error(errMsg, (Throwable)e);
            throw new MessagingException(errMsg, e);
        }
        log.info("Successfully signed message for {} with msg ID: {}", (Object)this.getCryptography(), (Object)msgId);
        this.traceMessage(msg, "Final email:\n{}\n");
    }

    protected abstract void sign(MimeMessage var1, T var2) throws Exception;

    protected void includeSignatureHeader(MimeMessage msg, String signatureAlgorithm) throws MessagingException {
        String headerPattern = this.isVerboseHeader() ? MAIL_HEADER_SIGNED_DEBUG_PATTERN : MAIL_HEADER_SIGNED_PATTERN;
        this.includeCryptographyHeader(msg, "X-Signed", headerPattern, new Object[]{this.getCryptography(), signatureAlgorithm});
    }

    protected boolean isVerboseHeader() {
        return this.getLog().isDebugEnabled();
    }
}

