/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.version;

import java.net.InetAddress;
import java.net.UnknownHostException;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.cryptography.version.IVersion;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductInformation
implements IVersion {
    private static final Logger log = LoggerFactory.getLogger(ProductInformation.class);
    private String product;
    private String version;
    private String host;

    public static final String loadHostName() {
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.warn("Could not retrieve host name.", (Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)host)) {
            try {
                host = System.getenv("COMPUTERNAME");
                if (StringUtils.isEmpty((CharSequence)host)) {
                    host = System.getenv("HOSTNAME");
                }
            }
            catch (SecurityException e) {
                log.warn("Could not retrieve host name from environment properties.", (Throwable)e);
            }
        }
        if (StringUtils.isEmpty((CharSequence)host)) {
            host = "<Unknown>";
        }
        log.info("Loaded host name: {}", (Object)host);
        return host;
    }

    public static final String loadVersion() {
        String compileTime;
        String versionNo = SecurityUtil.getManifestValue("Bundle-Version");
        if (versionNo == null) {
            log.warn("Bundle version is missing in manifest file.");
            versionNo = "<N/A>";
        }
        if ((compileTime = SecurityUtil.getManifestValue("Compile-Time")) == null) {
            log.warn("Compile time is missing in manifest file.");
            compileTime = "<N/A>";
        }
        StringBuilder builder = new StringBuilder(30);
        builder.append(versionNo);
        builder.append(" (");
        builder.append(compileTime);
        builder.append(')');
        String version = builder.toString();
        log.info("Loaded version: {}", (Object)version);
        return version;
    }

    public ProductInformation() {
    }

    public ProductInformation(String product, String version, String host) {
        this.product = product;
        this.version = version;
        this.host = host;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String toString() {
        return "ProductVersion [product=" + this.product + ", version=" + this.version + ", host=" + this.host + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.product == null ? 0 : this.product.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductInformation other = (ProductInformation)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.product == null ? other.product != null : !this.product.equals(other.product)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

