/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.mailer.keysource.smime;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.sal.api.component.ComponentLocator;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.naming.ConfigurationException;
import net.savignano.cryptography.connector.LdapConnector;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.smime.SmimeLdapLoader;
import net.savignano.cryptography.key.smime.SmimePublicKey;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.connector.AtlassianLdapConnector;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimePublicKeyManager;
import net.savignano.snotify.bitbucket.common.BitbucketUser;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketSmimeKeyManager
extends SmimePublicKeyManager {
    private static final Logger log = LoggerFactory.getLogger(BitbucketSmimeKeyManager.class);

    public BitbucketSmimeKeyManager(ISnotifyAppProperties appProps, ISnotifyUserProperties userProps) {
        super(appProps, userProps);
    }

    @Override
    protected List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SmimePublicKey, IUser<?>>>>>> getKeyLoaders() {
        List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SmimePublicKey, IUser<?>>>>>> loaders = super.getKeyLoaders();
        loaders.add(new AbstractMap.SimpleEntry<EKeySource, Supplier<Optional>>(EKeySource.ATLASSIAN_DIRECTORY, this::createAtlassianDirectoryLoader));
        return loaders;
    }

    private Optional<IKeyLoader<SmimePublicKey, IUser<?>>> createAtlassianDirectoryLoader() {
        if (!this.getAppProps().getBoolean(EProperty.USER_DIRECTORY_LDAP_QUERY_SMIME)) {
            log.debug("Retrieving certificate from LDAP server is disabled.");
            return Optional.empty();
        }
        IKeyLoader keyLoader = new IKeyLoader<SmimePublicKey, IUser<?>>(){

            @Override
            public SmimePublicKey loadKey(IUser<?> user) {
                DetailedUser detailedUser = BitbucketSmimeKeyManager.this.getDetailedUser(user);
                AtlassianLdapConnector connector = BitbucketSmimeKeyManager.this.getLdapConnector(detailedUser);
                if (connector == null) {
                    return BitbucketSmimeKeyManager.this.getValidityKey(EKeyValidity.NOT_FOUND, this.getKeySource());
                }
                String userFilter = "(" + connector.getUserNameKey() + "=" + detailedUser.getName() + ")";
                return (SmimePublicKey)BitbucketSmimeKeyManager.this.getLdapLoader(connector).loadKey((Pair<String, String>)Pair.of((Object)userFilter, (Object)detailedUser.getEmailAddress()));
            }

            @Override
            public EKeySource getKeySource() {
                return EKeySource.ATLASSIAN_DIRECTORY;
            }

            @Override
            public ECryptographyType getCryptography() {
                return ECryptographyType.SMIME;
            }
        };
        return Optional.of(keyLoader);
    }

    private SmimeLdapLoader getLdapLoader(LdapConnector connector) {
        SmimeLdapLoader loader = new SmimeLdapLoader(connector);
        loader.setKeySource(EKeySource.ATLASSIAN_DIRECTORY);
        if (this.getAppProps().hasKey(EProperty.TWEAK_LDAP_CONTEXT_REFERRAL)) {
            loader.setEnvironment(Collections.singletonMap("java.naming.referral", this.getAppProps().getString(EProperty.TWEAK_LDAP_CONTEXT_REFERRAL)));
        }
        loader.setExpectP7b(this.getAppProps().getBoolean(EProperty.TWEAK_EXPECT_P7B_IN_LDAP));
        return loader;
    }

    private AtlassianLdapConnector getLdapConnector(DetailedUser user) {
        Directory directory;
        if (user == null) {
            log.debug("Not a detailed user.");
            return null;
        }
        String directoryName = user.getDirectoryName();
        DirectoryManager manager = (DirectoryManager)ComponentLocator.getComponent(DirectoryManager.class);
        try {
            directory = manager.findDirectoryByName(directoryName);
        }
        catch (DirectoryNotFoundException e) {
            log.error("Could not find directory with name " + directoryName + ". Error message: " + e.getMessage(), (Throwable)e);
            return null;
        }
        if (!AtlassianLdapConnector.isConnector(directory)) {
            log.debug("Directory {} is not connecting to an LDAP.", (Object)directory.getName());
            return null;
        }
        try {
            AtlassianLdapConnector connector = AtlassianLdapConnector.createConnector(directory);
            connector.setDisableTrustCheck(connector.isDisableTrustCheck() && this.getAppProps().getBoolean(EProperty.TWEAK_USER_DIRECTORY_INSECURE));
            return connector;
        }
        catch (ConfigurationException e) {
            log.error("Could not create an LDAP from directory " + directory.getName() + ". Error message: " + e.getMessage());
            return null;
        }
    }

    private DetailedUser getDetailedUser(IUser<?> user) {
        if (user == null || !(user instanceof BitbucketUser)) {
            return null;
        }
        ApplicationUser appUser = ((BitbucketUser)user).getActualUser();
        if (appUser instanceof DetailedUser) {
            return (DetailedUser)appUser;
        }
        UserAdminService service = (UserAdminService)ComponentLocator.getComponent(UserAdminService.class);
        return service.getUserDetails(appUser);
    }
}

