/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1StreamParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObjectParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.BERTaggedObjectParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.DLApplicationSpecific;

class DLTaggedObjectParser
extends BERTaggedObjectParser {
    private final boolean _constructed;

    DLTaggedObjectParser(int tagClass, int tagNo, boolean constructed, ASN1StreamParser parser) {
        super(tagClass, tagNo, parser);
        this._constructed = constructed;
    }

    public boolean isConstructed() {
        return this._constructed;
    }

    public ASN1Primitive getLoadedObject() throws IOException {
        return this._parser.loadTaggedDL(this._tagClass, this._tagNo, this._constructed);
    }

    public ASN1Encodable parseBaseUniversal(boolean declaredExplicit, int baseTagNo) throws IOException {
        if (declaredExplicit) {
            if (!this._constructed) {
                throw new IOException("Explicit tags must be constructed (see X.690 8.14.2)");
            }
            return this._parser.parseObject(baseTagNo);
        }
        return this._constructed ? this._parser.parseImplicitConstructedDL(baseTagNo) : this._parser.parseImplicitPrimitive(baseTagNo);
    }

    public ASN1Encodable parseExplicitBaseObject() throws IOException {
        if (!this._constructed) {
            throw new IOException("Explicit tags must be constructed (see X.690 8.14.2)");
        }
        return this._parser.readObject();
    }

    public ASN1TaggedObjectParser parseExplicitBaseTagged() throws IOException {
        if (!this._constructed) {
            throw new IOException("Explicit tags must be constructed (see X.690 8.14.2)");
        }
        return this._parser.parseTaggedObject();
    }

    public ASN1TaggedObjectParser parseImplicitBaseTagged(int baseTagClass, int baseTagNo) throws IOException {
        if (64 == baseTagClass) {
            return (DLApplicationSpecific)this._parser.loadTaggedDL(baseTagClass, baseTagNo, this._constructed);
        }
        return new DLTaggedObjectParser(baseTagClass, baseTagNo, this._constructed, this._parser);
    }
}

