/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.cmp;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmp.PKIStatusInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmp.RevRepContent;
import net.savignano.thirdparty.org.bouncycastle.asn1.crmf.CertId;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.CertificateList;

public class RevRepContentBuilder {
    private final ASN1EncodableVector status = new ASN1EncodableVector();
    private final ASN1EncodableVector revCerts = new ASN1EncodableVector();
    private final ASN1EncodableVector crls = new ASN1EncodableVector();

    public RevRepContentBuilder add(PKIStatusInfo status) {
        this.status.add(status);
        return this;
    }

    public RevRepContentBuilder add(PKIStatusInfo status, CertId certId) {
        if (this.status.size() != this.revCerts.size()) {
            throw new IllegalStateException("status and revCerts sequence must be in common order");
        }
        this.status.add(status);
        this.revCerts.add(certId);
        return this;
    }

    public RevRepContentBuilder addCrl(CertificateList crl) {
        this.crls.add(crl);
        return this;
    }

    public RevRepContent build() {
        ASN1EncodableVector v = new ASN1EncodableVector(3);
        v.add(new DERSequence(this.status));
        if (this.revCerts.size() != 0) {
            v.add(new DERTaggedObject(true, 0, (ASN1Encodable)new DERSequence(this.revCerts)));
        }
        if (this.crls.size() != 0) {
            v.add(new DERTaggedObject(true, 1, (ASN1Encodable)new DERSequence(this.crls)));
        }
        return RevRepContent.getInstance(new DERSequence(v));
    }
}

