/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.bcpg.sig;

import java.io.ByteArrayOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SignatureSubpacket;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class NotationData
extends SignatureSubpacket {
    public static final int HEADER_FLAG_LENGTH = 4;
    public static final int HEADER_NAME_LENGTH = 2;
    public static final int HEADER_VALUE_LENGTH = 2;

    public NotationData(boolean critical, boolean isLongLength, byte[] data) {
        super(20, critical, isLongLength, data);
    }

    public NotationData(boolean critical, boolean humanReadable, String notationName, String notationValue) {
        super(20, critical, false, NotationData.createData(humanReadable, notationName, notationValue));
    }

    private static byte[] createData(boolean humanReadable, String notationName, String notationValue) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(humanReadable ? 128 : 0);
        out.write(0);
        out.write(0);
        out.write(0);
        byte[] valueData = null;
        byte[] nameData = Strings.toUTF8ByteArray(notationName);
        int nameLength = Math.min(nameData.length, 65535);
        if (nameLength != nameData.length) {
            throw new IllegalArgumentException("notationName exceeds maximum length.");
        }
        valueData = Strings.toUTF8ByteArray(notationValue);
        int valueLength = Math.min(valueData.length, 65535);
        if (valueLength != valueData.length) {
            throw new IllegalArgumentException("notationValue exceeds maximum length.");
        }
        out.write(nameLength >>> 8 & 0xFF);
        out.write(nameLength >>> 0 & 0xFF);
        out.write(valueLength >>> 8 & 0xFF);
        out.write(valueLength >>> 0 & 0xFF);
        out.write(nameData, 0, nameLength);
        out.write(valueData, 0, valueLength);
        return out.toByteArray();
    }

    public boolean isHumanReadable() {
        return this.data[0] == -128;
    }

    public String getNotationName() {
        int nameLength = ((this.data[4] & 0xFF) << 8) + (this.data[5] & 0xFF);
        byte[] bName = new byte[nameLength];
        System.arraycopy(this.data, 8, bName, 0, nameLength);
        return Strings.fromUTF8ByteArray(bName);
    }

    public String getNotationValue() {
        return Strings.fromUTF8ByteArray(this.getNotationValueBytes());
    }

    public byte[] getNotationValueBytes() {
        int nameLength = ((this.data[4] & 0xFF) << 8) + (this.data[5] & 0xFF);
        int valueLength = ((this.data[6] & 0xFF) << 8) + (this.data[7] & 0xFF);
        byte[] bValue = new byte[valueLength];
        System.arraycopy(this.data, 8 + nameLength, bValue, 0, valueLength);
        return bValue;
    }
}

