/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cms.jcajce;

import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.CMSORIforKEMOtherInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.KEMRecipientInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.CMSUtils;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.DefaultJcaJceExtHelper;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JcaJceExtHelper;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.NamedJcaJceExtHelper;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.ProviderJcaJceExtHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.spec.KTSParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.operator.AsymmetricKeyUnwrapper;
import net.savignano.thirdparty.org.bouncycastle.operator.GenericKey;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorException;
import net.savignano.thirdparty.org.bouncycastle.operator.jcajce.JceGenericKey;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

class JceCMSKEMKeyUnwrapper
extends AsymmetricKeyUnwrapper {
    private final AlgorithmIdentifier symWrapAlgorithm;
    private final int kekLength;
    private JcaJceExtHelper helper = new DefaultJcaJceExtHelper();
    private Map extraMappings = new HashMap();
    private PrivateKey privateKey;

    public JceCMSKEMKeyUnwrapper(AlgorithmIdentifier symWrapAlg, PrivateKey privateKey) {
        super(PrivateKeyInfo.getInstance(privateKey.getEncoded()).getPrivateKeyAlgorithm());
        KEMRecipientInfo gktParams = KEMRecipientInfo.getInstance(symWrapAlg.getParameters());
        this.privateKey = privateKey;
        this.symWrapAlgorithm = symWrapAlg;
        this.kekLength = CMSUtils.getKekSize(gktParams.getWrap().getAlgorithm());
    }

    public JceCMSKEMKeyUnwrapper setProvider(Provider provider) {
        this.helper = new ProviderJcaJceExtHelper(provider);
        return this;
    }

    public JceCMSKEMKeyUnwrapper setProvider(String providerName) {
        this.helper = new NamedJcaJceExtHelper(providerName);
        return this;
    }

    public JceCMSKEMKeyUnwrapper setAlgorithmMapping(ASN1ObjectIdentifier algorithm, String algorithmName) {
        this.extraMappings.put(algorithm, algorithmName);
        return this;
    }

    public int getKekLength() {
        return this.kekLength;
    }

    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptionKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        KEMRecipientInfo kemInfo = KEMRecipientInfo.getInstance(this.symWrapAlgorithm.getParameters());
        AlgorithmIdentifier symWrapAlgorithm = kemInfo.getWrap();
        try {
            byte[] oriInfoEnc = new CMSORIforKEMOtherInfo(symWrapAlgorithm, this.kekLength, kemInfo.getUkm()).getEncoded();
            if (this.privateKey instanceof RSAPrivateKey) {
                Cipher keyEncryptionCipher = CMSUtils.createAsymmetricWrapper(this.helper, kemInfo.getKem().getAlgorithm(), new HashMap());
                try {
                    String wrapAlgorithmName = CMSUtils.getWrapAlgorithmName(symWrapAlgorithm.getAlgorithm());
                    KTSParameterSpec ktsSpec = new KTSParameterSpec.Builder(wrapAlgorithmName, this.kekLength * 8, oriInfoEnc).withKdfAlgorithm(kemInfo.getKdf()).build();
                    keyEncryptionCipher.init(4, (Key)this.privateKey, ktsSpec);
                    Key wrapKey = keyEncryptionCipher.unwrap(Arrays.concatenate(kemInfo.getKemct().getOctets(), kemInfo.getEncryptedKey().getOctets()), wrapAlgorithmName, 3);
                    return new JceGenericKey(encryptionKeyAlgorithm, wrapKey);
                }
                catch (Exception e) {
                    throw new OperatorException("Unable to wrap contents key: " + e.getMessage(), e);
                }
            }
            Cipher keyEncryptionCipher = CMSUtils.createAsymmetricWrapper(this.helper, kemInfo.getKem().getAlgorithm(), new HashMap());
            String wrapAlgorithmName = CMSUtils.getWrapAlgorithmName(symWrapAlgorithm.getAlgorithm());
            KTSParameterSpec ktsSpec = new KTSParameterSpec.Builder(wrapAlgorithmName, this.kekLength * 8, oriInfoEnc).withKdfAlgorithm(kemInfo.getKdf()).build();
            keyEncryptionCipher.init(4, (Key)this.privateKey, ktsSpec);
            Key wrapKey = keyEncryptionCipher.unwrap(Arrays.concatenate(kemInfo.getKemct().getOctets(), kemInfo.getEncryptedKey().getOctets()), wrapAlgorithmName, 3);
            return new JceGenericKey(encryptionKeyAlgorithm, wrapKey);
        }
        catch (Exception e) {
            throw new OperatorException("exception encrypting key: " + e.getMessage(), e);
        }
    }
}

