/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cms.jcajce;

import java.security.PrivateKey;
import java.security.Provider;
import javax.crypto.SecretKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.CMSUtils;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JcaJceExtHelper;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JceCMSKEMKeyUnwrapper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.operator.AsymmetricKeyUnwrapper;
import net.savignano.thirdparty.org.bouncycastle.operator.SymmetricKeyUnwrapper;
import net.savignano.thirdparty.org.bouncycastle.operator.jcajce.JceAsymmetricKeyUnwrapper;
import net.savignano.thirdparty.org.bouncycastle.operator.jcajce.JceKTSKeyUnwrapper;
import net.savignano.thirdparty.org.bouncycastle.operator.jcajce.JceSymmetricKeyUnwrapper;

class ProviderJcaJceExtHelper
extends ProviderJcaJceHelper
implements JcaJceExtHelper {
    public ProviderJcaJceExtHelper(Provider provider) {
        super(provider);
    }

    public JceAsymmetricKeyUnwrapper createAsymmetricUnwrapper(AlgorithmIdentifier keyEncryptionAlgorithm, PrivateKey keyEncryptionKey) {
        keyEncryptionKey = CMSUtils.cleanPrivateKey(keyEncryptionKey);
        return new JceAsymmetricKeyUnwrapper(keyEncryptionAlgorithm, keyEncryptionKey).setProvider(this.provider);
    }

    public JceKTSKeyUnwrapper createAsymmetricUnwrapper(AlgorithmIdentifier keyEncryptionAlgorithm, PrivateKey keyEncryptionKey, byte[] partyUInfo, byte[] partyVInfo) {
        keyEncryptionKey = CMSUtils.cleanPrivateKey(keyEncryptionKey);
        return new JceKTSKeyUnwrapper(keyEncryptionAlgorithm, keyEncryptionKey, partyUInfo, partyVInfo).setProvider(this.provider);
    }

    public SymmetricKeyUnwrapper createSymmetricUnwrapper(AlgorithmIdentifier keyEncryptionAlgorithm, SecretKey keyEncryptionKey) {
        return new JceSymmetricKeyUnwrapper(keyEncryptionAlgorithm, keyEncryptionKey).setProvider(this.provider);
    }

    public AsymmetricKeyUnwrapper createKEMUnwrapper(AlgorithmIdentifier keyEncryptionAlgorithm, PrivateKey keyEncryptionKey) {
        return new JceCMSKEMKeyUnwrapper(keyEncryptionAlgorithm, keyEncryptionKey).setProvider(this.provider);
    }
}

