/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.its;

import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.its.ITSPublicEncryptionKey;
import net.savignano.thirdparty.org.bouncycastle.its.ITSValidityPeriod;
import net.savignano.thirdparty.org.bouncycastle.its.operator.ECDSAEncoder;
import net.savignano.thirdparty.org.bouncycastle.its.operator.ITSContentVerifierProvider;
import net.savignano.thirdparty.org.bouncycastle.oer.OEREncoder;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.CertificateBase;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.IssuerIdentifier;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.PublicEncryptionKey;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.Signature;
import net.savignano.thirdparty.org.bouncycastle.oer.its.template.ieee1609dot2.IEEE1609dot2;
import net.savignano.thirdparty.org.bouncycastle.operator.ContentVerifier;
import net.savignano.thirdparty.org.bouncycastle.util.Encodable;

public class ITSCertificate
implements Encodable {
    private final CertificateBase certificate;

    public ITSCertificate(CertificateBase certificate) {
        this.certificate = certificate;
    }

    public IssuerIdentifier getIssuer() {
        return this.certificate.getIssuer();
    }

    public ITSValidityPeriod getValidityPeriod() {
        return new ITSValidityPeriod(this.certificate.getToBeSigned().getValidityPeriod());
    }

    public ITSPublicEncryptionKey getPublicEncryptionKey() {
        PublicEncryptionKey encryptionKey = this.certificate.getToBeSigned().getEncryptionKey();
        if (encryptionKey != null) {
            return new ITSPublicEncryptionKey(encryptionKey);
        }
        return null;
    }

    public boolean isSignatureValid(ITSContentVerifierProvider verifierProvider) throws Exception {
        ContentVerifier contentVerifier = verifierProvider.get(this.certificate.getSignature().getChoice());
        OutputStream verOut = contentVerifier.getOutputStream();
        verOut.write(OEREncoder.toByteArray(this.certificate.getToBeSigned(), IEEE1609dot2.ToBeSignedCertificate.build()));
        verOut.close();
        Signature sig = this.certificate.getSignature();
        return contentVerifier.verify(ECDSAEncoder.toX962(sig));
    }

    public CertificateBase toASN1Structure() {
        return this.certificate;
    }

    public byte[] getEncoded() throws IOException {
        return OEREncoder.toByteArray(this.certificate, IEEE1609dot2.CertificateBase.build());
    }
}

