/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;

public abstract class SwitchIndexer {
    public abstract ASN1Encodable get(int var1);

    public static class FixedValueIndexer
    extends SwitchIndexer {
        private final ASN1Encodable returnValue;

        public FixedValueIndexer(ASN1Encodable returnValue) {
            this.returnValue = returnValue;
        }

        public ASN1Encodable get(int index) {
            return this.returnValue;
        }
    }

    public static class Asn1EncodableVectorIndexer
    extends SwitchIndexer {
        private final ASN1EncodableVector asn1EncodableVector;

        public Asn1EncodableVectorIndexer(ASN1EncodableVector asn1EncodableVector) {
            this.asn1EncodableVector = asn1EncodableVector;
        }

        public ASN1Encodable get(int index) {
            return this.asn1EncodableVector.get(index);
        }
    }

    public static class Asn1SequenceIndexer
    extends SwitchIndexer {
        private final ASN1Sequence sequence;

        public Asn1SequenceIndexer(ASN1Sequence sequence) {
            this.sequence = sequence;
        }

        public ASN1Encodable get(int index) {
            return this.sequence.getObjectAt(index);
        }
    }
}

