/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;

public class JcePBESecretKeyEncryptorBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private int encAlgorithm;
    private PGPDigestCalculator s2kDigestCalculator;
    private SecureRandom random;
    private int s2kCount = 96;

    public JcePBESecretKeyEncryptorBuilder(int encAlgorithm) {
        this(encAlgorithm, new SHA1PGPDigestCalculator());
    }

    public JcePBESecretKeyEncryptorBuilder(int encAlgorithm, int s2kCount) {
        this(encAlgorithm, new SHA1PGPDigestCalculator(), s2kCount);
    }

    public JcePBESecretKeyEncryptorBuilder(int encAlgorithm, PGPDigestCalculator s2kDigestCalculator) {
        this(encAlgorithm, s2kDigestCalculator, 96);
    }

    public JcePBESecretKeyEncryptorBuilder(int encAlgorithm, PGPDigestCalculator s2kDigestCalculator, int s2kCount) {
        this.encAlgorithm = encAlgorithm;
        this.s2kDigestCalculator = s2kDigestCalculator;
        if (s2kCount < 0 || s2kCount > 255) {
            throw new IllegalArgumentException("s2KCount value outside of range 0 to 255.");
        }
        this.s2kCount = s2kCount;
    }

    public JcePBESecretKeyEncryptorBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePBESecretKeyEncryptorBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JcePBESecretKeyEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public PBESecretKeyEncryptor build(char[] passPhrase) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return new PBESecretKeyEncryptor(this.encAlgorithm, this.s2kDigestCalculator, this.s2kCount, this.random, passPhrase){
            private Cipher c;
            private byte[] iv;

            public byte[] encryptKeyData(byte[] key, byte[] keyData, int keyOff, int keyLen) throws PGPException {
                try {
                    this.c = JcePBESecretKeyEncryptorBuilder.this.helper.createCipher(PGPUtil.getSymmetricCipherName(this.encAlgorithm) + "/CFB/NoPadding");
                    this.c.init(1, (Key)JcaJcePGPUtil.makeSymmetricKey(this.encAlgorithm, key), this.random);
                    this.iv = this.c.getIV();
                    return this.c.doFinal(keyData, keyOff, keyLen);
                }
                catch (IllegalBlockSizeException e) {
                    throw new PGPException("illegal block size: " + e.getMessage(), e);
                }
                catch (BadPaddingException e) {
                    throw new PGPException("bad padding: " + e.getMessage(), e);
                }
                catch (InvalidKeyException e) {
                    throw new PGPException("invalid key: " + e.getMessage(), e);
                }
            }

            public byte[] encryptKeyData(byte[] key, byte[] iv, byte[] keyData, int keyOff, int keyLen) throws PGPException {
                try {
                    this.c = JcePBESecretKeyEncryptorBuilder.this.helper.createCipher(PGPUtil.getSymmetricCipherName(this.encAlgorithm) + "/CFB/NoPadding");
                    this.c.init(1, (Key)JcaJcePGPUtil.makeSymmetricKey(this.encAlgorithm, key), new IvParameterSpec(iv));
                    this.iv = iv;
                    return this.c.doFinal(keyData, keyOff, keyLen);
                }
                catch (IllegalBlockSizeException e) {
                    throw new PGPException("illegal block size: " + e.getMessage(), e);
                }
                catch (BadPaddingException e) {
                    throw new PGPException("bad padding: " + e.getMessage(), e);
                }
                catch (InvalidKeyException e) {
                    throw new PGPException("invalid key: " + e.getMessage(), e);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new PGPException("invalid iv: " + e.getMessage(), e);
                }
            }

            public byte[] getCipherIV() {
                return this.iv;
            }
        };
    }
}

