/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.operator.bc;

import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.crypto.Signer;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.operator.ContentVerifier;
import net.savignano.thirdparty.org.bouncycastle.operator.ContentVerifierProvider;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;
import net.savignano.thirdparty.org.bouncycastle.operator.bc.BcDefaultDigestProvider;
import net.savignano.thirdparty.org.bouncycastle.operator.bc.BcDigestProvider;
import net.savignano.thirdparty.org.bouncycastle.operator.bc.BcSignerOutputStream;

public abstract class BcContentVerifierProviderBuilder {
    protected BcDigestProvider digestProvider = BcDefaultDigestProvider.INSTANCE;

    public ContentVerifierProvider build(final X509CertificateHolder certHolder) throws OperatorCreationException {
        return new ContentVerifierProvider(){

            public boolean hasAssociatedCertificate() {
                return true;
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return certHolder;
            }

            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                try {
                    AsymmetricKeyParameter publicKey = BcContentVerifierProviderBuilder.this.extractKeyParameters(certHolder.getSubjectPublicKeyInfo());
                    BcSignerOutputStream stream = BcContentVerifierProviderBuilder.this.createSignatureStream(algorithm, publicKey);
                    return new SigVerifier(algorithm, stream);
                }
                catch (IOException e) {
                    throw new OperatorCreationException("exception on setup: " + e, e);
                }
            }
        };
    }

    public ContentVerifierProvider build(final AsymmetricKeyParameter publicKey) throws OperatorCreationException {
        return new ContentVerifierProvider(){

            public boolean hasAssociatedCertificate() {
                return false;
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return null;
            }

            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                BcSignerOutputStream stream = BcContentVerifierProviderBuilder.this.createSignatureStream(algorithm, publicKey);
                return new SigVerifier(algorithm, stream);
            }
        };
    }

    private BcSignerOutputStream createSignatureStream(AlgorithmIdentifier algorithm, AsymmetricKeyParameter publicKey) throws OperatorCreationException {
        Signer sig = this.createSigner(algorithm);
        sig.init(false, publicKey);
        return new BcSignerOutputStream(sig);
    }

    protected abstract AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo var1) throws IOException;

    protected abstract Signer createSigner(AlgorithmIdentifier var1) throws OperatorCreationException;

    private static class SigVerifier
    implements ContentVerifier {
        private BcSignerOutputStream stream;
        private AlgorithmIdentifier algorithm;

        SigVerifier(AlgorithmIdentifier algorithm, BcSignerOutputStream stream) {
            this.algorithm = algorithm;
            this.stream = stream;
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithm;
        }

        public OutputStream getOutputStream() {
            if (this.stream == null) {
                throw new IllegalStateException("verifier not initialised");
            }
            return this.stream;
        }

        public boolean verify(byte[] expected) {
            return this.stream.verify(expected);
        }
    }
}

